/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calcorei;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.access.Acl;
import org.bedework.calfacade.BwEvent;

public class CoreEventInfo
implements Comparable,
Comparator,
Serializable {
    protected BwEvent event;
    private Acl.CurrentAccess currentAccess;
    private Collection<CoreEventInfo> overrides;
    private Collection<CoreEventInfo> instances;
    private Set<CoreEventInfo> containedItems;

    public CoreEventInfo() {
    }

    public CoreEventInfo(BwEvent event, Acl.CurrentAccess currentAccess) {
        this.event = event;
        this.currentAccess = currentAccess;
    }

    public void setEvent(BwEvent val) {
        this.event = val;
    }

    public BwEvent getEvent() {
        return this.event;
    }

    public Acl.CurrentAccess getCurrentAccess() {
        return this.currentAccess;
    }

    public void setOverrides(Collection<CoreEventInfo> val) {
        this.overrides = val;
    }

    public Collection<CoreEventInfo> getOverrides() {
        return this.overrides;
    }

    public int getNumOverrides() {
        Collection<CoreEventInfo> as = this.getOverrides();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    public void addOverride(CoreEventInfo val) {
        Collection<CoreEventInfo> as = this.getOverrides();
        if (as == null) {
            as = new TreeSet<CoreEventInfo>();
            this.setOverrides(as);
        }
        if (!as.contains(val)) {
            as.add(val);
        }
    }

    public boolean removeOverride(CoreEventInfo val) {
        Collection<CoreEventInfo> as = this.getOverrides();
        if (as == null) {
            return false;
        }
        return as.remove(val);
    }

    public void setInstances(Collection<CoreEventInfo> val) {
        this.instances = val;
    }

    public Collection<CoreEventInfo> getInstances() {
        return this.instances;
    }

    public void setContainedItems(Set<CoreEventInfo> val) {
        this.containedItems = val;
    }

    public Set<CoreEventInfo> getContainedItems() {
        return this.containedItems;
    }

    public void addContainedItem(CoreEventInfo val) {
        Set<CoreEventInfo> cis = this.getContainedItems();
        if (cis == null) {
            cis = new TreeSet<CoreEventInfo>();
            this.setContainedItems(cis);
        }
        cis.add(val);
    }

    public int getNumContainedItems() {
        Set<CoreEventInfo> cis = this.getContainedItems();
        if (cis == null) {
            return 0;
        }
        return cis.size();
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof CoreEventInfo)) {
            return -1;
        }
        if (!(o2 instanceof CoreEventInfo)) {
            return 1;
        }
        if (o1 == o2) {
            return 0;
        }
        CoreEventInfo e1 = (CoreEventInfo)o1;
        CoreEventInfo e2 = (CoreEventInfo)o2;
        return e1.getEvent().compare(e1.getEvent(), e2.getEvent());
    }

    public int compareTo(Object o2) {
        return this.compare(this, o2);
    }

    public int hashCode() {
        return this.getEvent().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CoreEventInfo)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EventInfo{eventid=");
        if (this.getEvent() == null) {
            sb.append("UNKNOWN");
        } else {
            sb.append(this.getEvent().getId());
        }
        return sb.toString();
    }
}

