/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.hnd;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.fct.IFcCsvDrt;
import org.beigesoft.hnd.IHnTrRlBk;
import org.beigesoft.hnd.IHndFlRpRq;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.CsvCl;
import org.beigesoft.mdlp.CsvMth;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.ICsvDtRet;
import org.beigesoft.srv.ICsvWri;

public class HndCsvWri<RS>
implements IHndFlRpRq {
    private ILog logStd;
    private IRdb<RS> rdb;
    private IOrm orm;
    private ICsvWri csvWri;
    private IFcCsvDrt fctRet;

    @Override
    public final void handle(Map<String, Object> pRvs, IReqDt pRqDt, OutputStream pSous) throws Exception {
        String csMtIdStr = pRqDt.getParam("CsvMth");
        Long csMtId = Long.parseLong(csMtIdStr);
        CsvMth csMt = null;
        List<List<Object>> data = null;
        ICsvDtRet ret = null;
        HashMap<String, Object> vs = new HashMap<String, Object>();
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(IRdb.TRRUC);
            this.rdb.begin();
            CsvMth csMtt = new CsvMth();
            csMtt.setIid(csMtId);
            csMt = this.getOrm().retEnt(pRvs, vs, csMtt);
            List<CsvCl> cols = this.getOrm().retLstCnd(pRvs, vs, CsvCl.class, "where OWNR=" + csMt.getIid());
            csMt.setClns(cols);
            ret = this.fctRet.laz(pRvs, csMt.getRtrNm());
            if (ret == null) {
                throw new ExcCode(1001, "Can't find retriever " + csMt.getRtrNm());
            }
            data = ret.retData(pRvs, pRqDt);
            this.rdb.commit();
        }
        catch (Exception ex) {
            Set hnsTrRlBk = (Set)pRvs.get("hnsTrRlBk");
            if (hnsTrRlBk != null) {
                pRvs.remove("hnsTrRlBk");
                for (IHnTrRlBk hnTrRlBk : hnsTrRlBk) {
                    try {
                        hnTrRlBk.hndRlBk(pRvs);
                    }
                    catch (Exception ex1) {
                        this.logStd.error(pRvs, this.getClass(), "Handler roll back: ", (Throwable)ex1);
                    }
                }
            }
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        if (data != null) {
            this.csvWri.write(pRvs, data, csMt, pSous);
        }
    }

    public final ILog getLogStd() {
        return this.logStd;
    }

    public final void setLogStd(ILog pLogStd) {
        this.logStd = pLogStd;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ICsvWri getCsvWri() {
        return this.csvWri;
    }

    public final void setCsvWri(ICsvWri pCsvWri) {
        this.csvWri = pCsvWri;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final IFcCsvDrt getFctRet() {
        return this.fctRet;
    }

    public final void setFctRet(IFcCsvDrt pFctRet) {
        this.fctRet = pFctRet;
    }
}

