/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.hnd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.beigesoft.cnv.IFilEntRq;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.fct.IFcClFcRq;
import org.beigesoft.fct.IFctPrc;
import org.beigesoft.fct.IFctPrcEnt;
import org.beigesoft.fct.IFctRq;
import org.beigesoft.hld.IHlNmClSt;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.hnd.IHnTrRlBk;
import org.beigesoft.hnd.IHndRq;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IRdb;

public class HndEntRq<RS>
implements IHndRq {
    private ILog logStd;
    private ILog logSec;
    private IRdb<RS> rdb;
    private IFilEntRq filEntRq;
    private IFcClFcRq fctFctEnt;
    private IHlNmClSt hldEntPrcNm;
    private IFctPrcEnt fctEntPrc;
    private IHlNmClSt hldPrcFenNm;
    private IFctPrc fctPrcFen;
    private Map<String, Class<? extends IHasId<?>>> entMap;
    private Integer writeTi = IRdb.TRRUC;
    private Integer readTi = IRdb.TRRC;
    private Integer writeReTi = IRdb.TRRUC;
    private Boolean wrReSpTr = Boolean.FALSE;

    @Override
    public final void handle(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String[] actArr;
        String entNm = pRqDt.getParam("ent");
        if (entNm == null) {
            return;
        }
        pRqDt.setAttr("urlPrf", "../");
        Class<? extends IHasId<?>> cls = this.entMap.get(entNm);
        if (cls == null) {
            this.logSec.error(pRvs, HndEntRq.class, "Trying to work with forbidden ent/host/addr/port/user: " + entNm + "/" + pRqDt.getRemHost() + "/" + pRqDt.getRemAddr() + "/" + pRqDt.getRemPort() + "/" + pRqDt.getUsrNm());
            throw new ExcCode(403, "FORB");
        }
        UvdVar uvs = new UvdVar();
        pRvs.put("uvs", uvs);
        boolean dbgSh = this.getLogStd().getDbgSh(this.getClass(), 5550);
        for (String actNm : actArr = pRqDt.getParam("act").split(",")) {
            if (!dbgSh) continue;
            this.logStd.debug(pRvs, HndEntRq.class, "Action: " + actNm);
        }
        if (this.wrReSpTr.booleanValue() && ("entSv".equals(actArr[0]) || "entOwSv".equals(actArr[0]) || "entDl".equals(actArr[0]) || "entOwDl".equals(actArr[0]))) {
            this.hndChngIsl(pRvs, pRqDt, cls, actArr, dbgSh, entNm);
        } else {
            this.hndNoChngIsl(pRvs, pRqDt, cls, actArr, dbgSh, entNm);
        }
    }

    public final <T extends IHasId<?>> void hndChngIsl(Map<String, Object> pRvs, IReqDt pRqDt, Class<T> pCls, String[] pActArr, boolean pIsDbgSh, String pNmEnt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        Class<Object> cls = pCls;
        IHasId<?> ent = null;
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.writeTi);
            this.rdb.begin();
            IFctRq<T> entFac = this.fctFctEnt.laz(pRvs, cls);
            ent = (IHasId<?>)entFac.create(pRvs);
            this.filEntRq.fill(pRvs, vs, ent, pRqDt);
            String entProcNm = this.hldEntPrcNm.get(cls, pActArr[0]);
            if (entProcNm == null) {
                this.logSec.error(null, HndEntRq.class, "Trying to work with forbidden ent/action/user: " + ent + "/" + pActArr[0] + "/" + pRqDt.getUsrNm());
                throw new ExcCode(403, "Forbidden!");
            }
            IPrcEnt<?, ?> ep = this.fctEntPrc.laz(pRvs, entProcNm);
            if (pIsDbgSh) {
                this.logStd.debug(pRvs, HndEntRq.class, "CHANGING transaction use entProcNm/IPrcEnt: " + entProcNm + "/" + ep.getClass());
            }
            ent = ep.process(pRvs, ent, pRqDt);
            this.rdb.commit();
        }
        catch (Exception ex) {
            Set hnsTrRlBk = (Set)pRvs.get("hnsTrRlBk");
            if (hnsTrRlBk != null) {
                pRvs.remove("hnsTrRlBk");
                for (IHnTrRlBk hnTrRlBk : hnsTrRlBk) {
                    try {
                        hnTrRlBk.hndRlBk(pRvs);
                    }
                    catch (Exception ex1) {
                        this.logStd.error(pRvs, this.getClass(), "Handler roll back: ", (Throwable)ex1);
                    }
                }
            }
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        if (pActArr.length > 1) {
            try {
                this.rdb.setAcmt(false);
                this.rdb.setTrIsl(this.readTi);
                this.rdb.begin();
                for (int i = 1; i < pActArr.length; ++i) {
                    String actNm = pActArr[i];
                    if (actNm.startsWith("ent")) {
                        String entProcNm;
                        if (ent == null) {
                            ent = uvs.getOwnr();
                            if (ent == null) {
                                throw new ExcCode(1001, "wrong_request_entity_not_filled");
                            }
                            cls = ent.getClass();
                        }
                        if ((entProcNm = this.hldEntPrcNm.get(cls, actNm)) == null) {
                            this.logSec.error(null, HndEntRq.class, "Trying to work with forbidden ent/action/user: " + ent + "/" + actNm + "/" + pRqDt.getUsrNm());
                            throw new ExcCode(403, "Forbidden!");
                        }
                        IPrcEnt<?, ?> ep = this.fctEntPrc.laz(pRvs, entProcNm);
                        if (pIsDbgSh) {
                            this.logStd.debug(pRvs, HndEntRq.class, "It's used entProcNm/IPrcEnt: " + entProcNm + "/" + ep.getClass());
                        }
                        ent = ep.process(pRvs, ent, pRqDt);
                        continue;
                    }
                    String procNm = this.hldPrcFenNm.get(cls, actNm);
                    if (procNm == null) {
                        this.logSec.error(pRvs, HndEntRq.class, "Trying to work with forbidden ent/action/user: " + ent + "/" + actNm + "/" + pRqDt.getUsrNm());
                        throw new ExcCode(403, "Forbidden!");
                    }
                    IPrc proc = this.fctPrcFen.laz(pRvs, procNm);
                    if (pIsDbgSh) {
                        this.logStd.debug(pRvs, HndEntRq.class, "It's used procNm/IPrc: " + procNm + "/" + proc.getClass());
                    }
                    proc.process(pRvs, pRqDt);
                }
                this.rdb.commit();
            }
            catch (Exception ex) {
                Set hnsTrRl = (Set)pRvs.get("hnsTrRlBk");
                if (hnsTrRl != null) {
                    pRvs.remove("hnsTrRlBk");
                    for (IHnTrRlBk hnTrRlBk : hnsTrRl) {
                        try {
                            hnTrRlBk.hndRlBk(pRvs);
                        }
                        catch (Exception ex1) {
                            this.logStd.error(pRvs, this.getClass(), "Handler roll back: ", (Throwable)ex1);
                        }
                    }
                }
                if (!this.rdb.getAcmt()) {
                    this.rdb.rollBack();
                }
                throw ex;
            }
            finally {
                this.rdb.release();
            }
        }
    }

    public final <T extends IHasId<?>> void hndNoChngIsl(Map<String, Object> pRvs, IReqDt pRqDt, Class<T> pCls, String[] pActArr, boolean pIsDbgSh, String pNmEnt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        Class<Object> cls = pCls;
        IHasId<?> ent = null;
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.writeReTi);
            this.rdb.begin();
            if (pActArr[0].startsWith("ent")) {
                IFctRq<T> entFac = this.fctFctEnt.laz(pRvs, cls);
                ent = (IHasId<?>)entFac.create(pRvs);
                this.filEntRq.fill(pRvs, vs, ent, pRqDt);
            }
            for (String actNm : pActArr) {
                if (actNm.startsWith("ent")) {
                    String entProcNm;
                    if (ent == null) {
                        ent = uvs.getOwnr();
                        if (ent == null) {
                            throw new ExcCode(1001, "wrong_request_entity_not_filled");
                        }
                        cls = ent.getClass();
                    }
                    if ((entProcNm = this.hldEntPrcNm.get(cls, actNm)) == null) {
                        this.logSec.error(pRvs, HndEntRq.class, "Trying to work with forbidden ent/action/user: " + pNmEnt + "/" + (String)actNm + "/" + pRqDt.getUsrNm());
                        throw new ExcCode(403, "Forbidden!");
                    }
                    IPrcEnt<?, ?> ep = this.fctEntPrc.laz(pRvs, entProcNm);
                    if (pIsDbgSh) {
                        this.logStd.debug(pRvs, HndEntRq.class, "It's used entProcNm/IPrcEnt: " + entProcNm + "/" + ep.getClass());
                    }
                    ent = ep.process(pRvs, ent, pRqDt);
                    continue;
                }
                String procNm = this.hldPrcFenNm.get(cls, actNm);
                if (procNm == null) {
                    this.logSec.error(pRvs, HndEntRq.class, "Trying to work with forbidden ent/action/user: " + pNmEnt + "/" + (String)actNm + "/" + pRqDt.getUsrNm());
                    throw new ExcCode(403, "Forbidden!");
                }
                IPrc proc = this.fctPrcFen.laz(pRvs, procNm);
                if (pIsDbgSh) {
                    this.logStd.debug(pRvs, HndEntRq.class, "It's used procNm/IPrc: " + procNm + "/" + proc.getClass());
                }
                proc.process(pRvs, pRqDt);
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            Set hnsTrRlBk = (Set)pRvs.get("hnsTrRlBk");
            if (hnsTrRlBk != null) {
                pRvs.remove("hnsTrRlBk");
                for (IHnTrRlBk hnTrRlBk : hnsTrRlBk) {
                    try {
                        hnTrRlBk.hndRlBk(pRvs);
                    }
                    catch (Exception ex1) {
                        this.logStd.error(pRvs, this.getClass(), "Handler roll back: ", (Throwable)ex1);
                    }
                }
            }
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    public final ILog getLogStd() {
        return this.logStd;
    }

    public final void setLogStd(ILog pLogStd) {
        this.logStd = pLogStd;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final IFilEntRq getFilEntRq() {
        return this.filEntRq;
    }

    public final void setFilEntRq(IFilEntRq pFilEntRq) {
        this.filEntRq = pFilEntRq;
    }

    public final IFcClFcRq getFctFctEnt() {
        return this.fctFctEnt;
    }

    public final void setFctFctEnt(IFcClFcRq pFctFctEnt) {
        this.fctFctEnt = pFctFctEnt;
    }

    public final IFctPrcEnt getFctEntPrc() {
        return this.fctEntPrc;
    }

    public final void setFctEntPrc(IFctPrcEnt pFctEntPrc) {
        this.fctEntPrc = pFctEntPrc;
    }

    public final IHlNmClSt getHldEntPrcNm() {
        return this.hldEntPrcNm;
    }

    public final void setHldEntPrcNm(IHlNmClSt pHldEntPrcNm) {
        this.hldEntPrcNm = pHldEntPrcNm;
    }

    public final IFctPrc getFctPrcFen() {
        return this.fctPrcFen;
    }

    public final void setFctPrcFen(IFctPrc pFctPrcFen) {
        this.fctPrcFen = pFctPrcFen;
    }

    public final IHlNmClSt getHldPrcFenNm() {
        return this.hldPrcFenNm;
    }

    public final void setHldPrcFenNm(IHlNmClSt pHdPrcFenNm) {
        this.hldPrcFenNm = pHdPrcFenNm;
    }

    public final Map<String, Class<? extends IHasId<?>>> getEntMap() {
        return this.entMap;
    }

    public final void setEntMap(Map<String, Class<? extends IHasId<?>>> pEntMap) {
        this.entMap = pEntMap;
    }

    public final Integer getWriteTi() {
        return this.writeTi;
    }

    public final void setWriteTi(Integer pWriteTi) {
        this.writeTi = pWriteTi;
    }

    public final ILog getLogSec() {
        return this.logSec;
    }

    public final void setLogSec(ILog pLogSec) {
        this.logSec = pLogSec;
    }

    public final Integer getReadTi() {
        return this.readTi;
    }

    public final void setReadTi(Integer pReadTi) {
        this.readTi = pReadTi;
    }

    public final Integer getWriteReTi() {
        return this.writeReTi;
    }

    public final void setWriteReTi(Integer pWriteReTi) {
        this.writeReTi = pWriteReTi;
    }

    public final Boolean getWrReSpTr() {
        return this.wrReSpTr;
    }

    public final void setWrReSpTr(Boolean pWrReSpTr) {
        this.wrReSpTr = pWrReSpTr;
    }
}

