/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.hnd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.hld.HlMaFrCl;
import org.beigesoft.hld.HldUvd;
import org.beigesoft.hnd.IHndCh;
import org.beigesoft.hnd.IHndRq;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.AIdStrNm;
import org.beigesoft.mdlp.DcGrSp;
import org.beigesoft.mdlp.DcSp;
import org.beigesoft.mdlp.Lng;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.INumStr;
import org.beigesoft.srv.ISrvDt;
import org.beigesoft.srv.UtlJsp;

public class HndI18nRq<RS>
implements IHndRq,
IHndCh {
    private ILog log;
    private IRdb<RS> rdb;
    private IOrm orm;
    private II18n i18n;
    private UtlJsp utJsp;
    private ISrvDt srvDt;
    private INumStr numStr;
    private HlMaFrCl hlMaFrCl;
    private HldUvd hldUvd;
    private List<UsPrf> usPrfs;
    private List<Lng> lngs;
    private List<DcSp> dcSps;
    private List<DcGrSp> dcGrSps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(Map<String, Object> pRvs, IReqDt pRqd) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 5500);
        if (dbgSh) {
            this.log.debug(pRvs, HndI18nRq.class, "Request user/URL/rem.user/addr/host/port/locale: " + pRqd.getUsrNm() + "/" + pRqd.getReqUrl() + "/" + pRqd.getRemUsr() + "/" + pRqd.getRemAddr() + "/" + pRqd.getRemHost() + "/" + pRqd.getRemPort() + "/" + pRqd.getLocale());
            StringBuffer prs = new StringBuffer();
            for (Map.Entry<String, String[]> enr : pRqd.getParamMap().entrySet()) {
                prs.append(enr.getKey() + "-" + Arrays.toString(enr.getValue()) + "; ");
            }
            this.log.debug(pRvs, HndI18nRq.class, "Request parameters: " + prs);
            this.log.debug(pRvs, HndI18nRq.class, "Request cookies: " + Arrays.toString(pRqd.getCookies()));
        }
        HashMap<String, Object> vs = new HashMap<String, Object>();
        List<UsPrf> upfsTmp = null;
        List<Lng> lgsTmp = null;
        List<DcSp> dssTmp = null;
        List<DcGrSp> dgssTmp = null;
        boolean tmpReady = false;
        if (this.usPrfs == null) {
            HndI18nRq hndI18nRq = this;
            synchronized (hndI18nRq) {
                if (this.usPrfs == null) {
                    try {
                        this.log.info(pRvs, HndI18nRq.class, "Refreshing preferences...");
                        this.rdb.setAcmt(false);
                        this.rdb.setTrIsl(IRdb.TRRUC);
                        this.rdb.begin();
                        upfsTmp = this.orm.retLst(pRvs, vs, UsPrf.class);
                        lgsTmp = this.orm.retLst(pRvs, vs, Lng.class);
                        dssTmp = this.orm.retLst(pRvs, vs, DcSp.class);
                        dgssTmp = this.orm.retLst(pRvs, vs, DcGrSp.class);
                        this.rdb.commit();
                        this.dcGrSps = dgssTmp;
                        this.dcSps = dssTmp;
                        this.lngs = lgsTmp;
                        this.usPrfs = upfsTmp;
                        tmpReady = true;
                    }
                    catch (Exception ex) {
                        if (!this.rdb.getAcmt()) {
                            this.rdb.rollBack();
                        }
                        throw ex;
                    }
                    finally {
                        this.rdb.release();
                    }
                }
            }
        }
        if (!tmpReady) {
            upfsTmp = this.usPrfs;
            lgsTmp = this.lngs;
            dssTmp = this.dcSps;
            dgssTmp = this.dcGrSps;
        }
        UsPrf upf = this.revUsPrf(pRqd, lgsTmp, dssTmp, dgssTmp, upfsTmp);
        CmnPrf cpf = this.revCmnPrf(pRqd, upf);
        for (UsPrf upft : upfsTmp) {
            if (!upft.getDef().booleanValue()) continue;
            cpf.setLngDef(upft.getLng());
            break;
        }
        if (upfsTmp.size() == 0 || cpf.getLngDef() == null) {
            this.log.error(pRvs, HndI18nRq.class, "There is no default user preferences!");
            cpf.setLngDef(upf.getLng());
        }
        Locale locCurr = pRqd.getLocale().getLanguage().equals(upf.getLng().getIid()) ? pRqd.getLocale() : new Locale(upf.getLng().getIid());
        cpf.setUsLoc(locCurr);
        pRvs.put("upf", upf);
        pRvs.put("cpf", cpf);
        pRvs.put("lngs", this.lngs);
        pRvs.put("dcSps", this.dcSps);
        pRvs.put("dcGrSps", this.dcGrSps);
        pRvs.put("usPrfs", this.usPrfs);
        pRqd.setAttr("hldUvd", this.hldUvd);
        pRqd.setAttr("utJsp", this.utJsp);
        pRqd.setAttr("i18n", this.i18n);
        pRqd.setAttr("srvDt", this.srvDt);
        pRqd.setAttr("numStr", this.numStr);
        pRqd.setAttr("hlMaFrCl", this.hlMaFrCl);
    }

    public final CmnPrf revCmnPrf(IReqDt pRqd, UsPrf pUpf) {
        CmnPrf cpf = new CmnPrf();
        if (pUpf.getDcSp().getIid().equals("SPACE")) {
            cpf.setDcSpv("\u00a0");
        } else if (pUpf.getDcSp().getIid().equals("EMPTY")) {
            cpf.setDcSpv("");
        } else {
            cpf.setDcSpv(pUpf.getDcSp().getIid());
        }
        if (pUpf.getDcGrSp().getIid().equals("SPACE")) {
            cpf.setDcGrSpv("\u00a0");
        } else if (pUpf.getDcGrSp().getIid().equals("EMPTY")) {
            cpf.setDcGrSpv("");
        } else {
            cpf.setDcGrSpv(pUpf.getDcGrSp().getIid());
        }
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 5501);
        boolean ndStCk = false;
        String pgSz = pRqd.getParam("pgSz");
        if (dbgSh) {
            this.log.debug(null, HndI18nRq.class, "Request pgSz: " + pgSz);
        }
        if (pgSz != null) {
            ndStCk = true;
        } else {
            pgSz = pRqd.getCookVl("pgSz");
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Cookie pgSz: " + pgSz);
            }
        }
        if (pgSz != null) {
            cpf.setPgSz(Integer.valueOf(pgSz));
            if (cpf.getPgSz() > 100) {
                cpf.setPgSz(100);
            } else if (cpf.getPgSz() < 5) {
                cpf.setPgSz(5);
            }
        }
        if (ndStCk) {
            pRqd.setCookVl("pgSz", cpf.getPgSz().toString());
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Set cookie to pgSz: " + pgSz);
            }
        }
        return cpf;
    }

    public final UsPrf revUsPrf(IReqDt pRqd, List<Lng> pLngs, List<DcSp> pDcSps, List<DcGrSp> pDcGrSps, List<UsPrf> pUsPrfs) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 5502);
        UsPrf upf = null;
        boolean ndStCk = false;
        String lng = pRqd.getParam("lng");
        String dcSp = pRqd.getParam("dcSp");
        String dcGrSp = pRqd.getParam("dcGrSp");
        String dgInGr = pRqd.getParam("dgInGr");
        if (dbgSh) {
            this.log.debug(null, HndI18nRq.class, "Request lng/dcSp/dcGrSp/dgInGr: " + lng + "/" + dcSp + "/" + dcGrSp + "/" + dgInGr);
        }
        if (lng == null || lng.length() == 0 || dcSp == null || dcSp.length() == 0 || dcGrSp == null || dcGrSp.length() == 0 || dgInGr == null || dgInGr.length() == 0) {
            lng = null;
            dcSp = null;
            dcGrSp = null;
            dgInGr = null;
        } else {
            ndStCk = true;
        }
        if (dcGrSp == null && dcSp == null && lng == null) {
            lng = pRqd.getCookVl("lng");
            dcSp = pRqd.getCookVl("dcSp");
            if ("COMMA".equals(dcSp)) {
                dcSp = ",";
            }
            if ("COMMA".equals(dcGrSp = pRqd.getCookVl("dcGrSp"))) {
                dcGrSp = ",";
            }
            dgInGr = pRqd.getCookVl("dgInGr");
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Cookie lng/dcSp/dcGrSp/dgInGr: " + lng + "/" + dcSp + "/" + dcGrSp + "/" + dgInGr);
            }
        }
        if (dcGrSp != null && dcSp != null && lng != null && dgInGr != null) {
            if (dcGrSp.equals(dcSp)) {
                this.log.error(null, HndI18nRq.class, "Separators are same!! dcSp/dcGrSp: " + dcSp);
            } else {
                upf = new UsPrf();
                upf.setDgInGr(Integer.parseInt(dgInGr));
                for (Lng ln : pLngs) {
                    if (!ln.getIid().equals(lng)) continue;
                    upf.setLng(ln);
                    break;
                }
                if (upf.getLng() == null) {
                    upf = null;
                } else {
                    for (DcSp ds : pDcSps) {
                        if (!ds.getIid().equals(dcSp)) continue;
                        upf.setDcSp(ds);
                        break;
                    }
                    if (upf.getDcSp() == null) {
                        upf = null;
                    } else {
                        for (DcGrSp dgs : pDcGrSps) {
                            if (!dgs.getIid().equals(dcGrSp)) continue;
                            upf.setDcGrSp(dgs);
                            break;
                        }
                        if (upf.getDcGrSp() == null) {
                            upf = null;
                        }
                    }
                }
            }
        }
        if (upf == null && pUsPrfs.size() > 0) {
            upf = this.revUsPrfDb(pRqd, pLngs, pDcSps, pDcGrSps, pUsPrfs);
            ndStCk = true;
        }
        if (upf == null) {
            upf = this.revUsPrfSys(pRqd, pLngs, pDcSps, pDcGrSps, pUsPrfs);
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Use system lng/dcSp/dcGrSp: " + upf.getLng().getIid() + "/" + upf.getDcSp().getIid() + "/" + upf.getDcGrSp().getIid());
            }
            ndStCk = true;
        }
        if (ndStCk) {
            pRqd.setCookVl("dgInGr", upf.getDgInGr().toString());
            pRqd.setCookVl("lng", upf.getLng().getIid());
            String dcSpc = upf.getDcSp().getIid().equals(",") ? "COMMA" : upf.getDcSp().getIid();
            pRqd.setCookVl("dcSp", dcSpc);
            String dcGrSpc = upf.getDcGrSp().getIid().equals(",") ? "COMMA" : upf.getDcGrSp().getIid();
            pRqd.setCookVl("dcGrSp", dcGrSpc);
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Set cookie to lng/dcSp/dcGrSp: " + upf.getLng().getIid() + "/" + upf.getDcSp().getIid() + "/" + upf.getDcGrSp().getIid());
            }
        }
        return upf;
    }

    public final UsPrf revUsPrfSys(IReqDt pRqd, List<Lng> pLngs, List<DcSp> pDcSps, List<DcGrSp> pDcGrSps, List<UsPrf> pUsPrfs) throws Exception {
        AIdStrNm sp;
        UsPrf upf = new UsPrf();
        Locale lc = pRqd.getLocale();
        if (lc == null) {
            lc = Locale.getDefault();
        }
        if (pLngs.size() > 0) {
            for (Lng ln : pLngs) {
                if (!ln.getIid().equals(lc.getLanguage())) continue;
                upf.setLng(ln);
                break;
            }
        }
        if (upf.getLng() == null) {
            Lng ln = new Lng();
            ln.setIid(lc.getLanguage());
            ln.setNme(lc.getLanguage());
            upf.setLng(ln);
        }
        if (pDcSps.size() > 0) {
            upf.setDcSp(pDcSps.get(0));
        }
        if (upf.getDcSp() == null) {
            sp = new DcSp();
            sp.setIid(".");
            sp.setNme("Dot");
            upf.setDcSp((DcSp)sp);
        }
        if (pDcGrSps.size() > 0) {
            upf.setDcGrSp(pDcGrSps.get(0));
        }
        if (upf.getDcGrSp() == null) {
            sp = new DcGrSp();
            sp.setIid(",");
            sp.setNme("Comma");
            upf.setDcGrSp((DcGrSp)sp);
        }
        return upf;
    }

    public final UsPrf revUsPrfDb(IReqDt pRqd, List<Lng> pLngs, List<DcSp> pDcSps, List<DcGrSp> pDcGrSps, List<UsPrf> pUsPrfs) throws Exception {
        UsPrf upf = null;
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 5503);
        String ccountry = null;
        String clang = null;
        if (pRqd.getLocale() != null) {
            ccountry = pRqd.getLocale().getCountry();
            clang = pRqd.getLocale().getLanguage();
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Client prefers lng/country: " + clang + "/" + ccountry);
            }
        }
        UsPrf upfMf = null;
        UsPrf upfMl = null;
        UsPrf upfDef = null;
        for (UsPrf upft : pUsPrfs) {
            if (upft.getCntr().getIid().equals(ccountry) && upft.getLng().getIid().equals(clang)) {
                upfMf = upft;
                break;
            }
            if (upft.getLng().getIid().equals(clang)) {
                upfMl = upft;
            }
            if (upft.getDef().booleanValue()) {
                upfDef = upft;
                continue;
            }
            if (upfDef != null) continue;
            upfDef = upft;
        }
        if (upfMf != null) {
            upf = upfMf;
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Full match lng/dcSp/dcGrSp/dgInGr: " + upf.getLng().getIid() + "/" + upf.getDcSp().getIid() + "/" + upf.getDcGrSp().getIid() + "/" + upf.getDgInGr());
            }
        } else if (upfMl != null) {
            upf = upfMl;
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Lang match lng/dcSp/dcGrSp/dgInGr: " + upf.getLng().getIid() + "/" + upf.getDcSp().getIid() + "/" + upf.getDcGrSp().getIid() + "/" + upf.getDgInGr());
            }
        } else {
            upf = upfDef;
            if (dbgSh) {
                this.log.debug(null, HndI18nRq.class, "Default lng/dcSp/dcGrSp/dgInGr: " + upf.getLng().getIid() + "/" + upf.getDcSp().getIid() + "/" + upf.getDcGrSp().getIid() + "/" + upf.getDgInGr());
            }
        }
        return upf;
    }

    @Override
    public final synchronized void hndChange() throws Exception {
        this.usPrfs = null;
        this.lngs = null;
        this.dcSps = null;
        this.dcGrSps = null;
        this.log.info(null, HndI18nRq.class, "User preferences changes handled.");
    }

    public final synchronized ILog getLog() {
        return this.log;
    }

    public final synchronized void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final synchronized IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final synchronized void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final synchronized IOrm getOrm() {
        return this.orm;
    }

    public final synchronized void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final UtlJsp getUtJsp() {
        return this.utJsp;
    }

    public final void setUtJsp(UtlJsp pUtJsp) {
        this.utJsp = pUtJsp;
    }

    public final ISrvDt getSrvDt() {
        return this.srvDt;
    }

    public final void setSrvDt(ISrvDt pSrvDt) {
        this.srvDt = pSrvDt;
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }

    public final HlMaFrCl getHlMaFrCl() {
        return this.hlMaFrCl;
    }

    public final void setHlMaFrCl(HlMaFrCl pHlMaFrCl) {
        this.hlMaFrCl = pHlMaFrCl;
    }

    public final HldUvd getHldUvd() {
        return this.hldUvd;
    }

    public final void setHldUvd(HldUvd pHldUvd) {
        this.hldUvd = pHldUvd;
    }
}

