/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.ResultSet;
import java.util.Map;
import javax.sql.DataSource;
import org.beigesoft.fct.FctBlc;
import org.beigesoft.fct.IFctAux;
import org.beigesoft.jdbc.Rdb;
import org.beigesoft.rdb.IRdb;

public class FctSqlite
implements IFctAux<ResultSet> {
    private HikariDataSource ds;

    @Override
    public final Object crePut(Map<String, Object> pRqVs, String pBnNm, FctBlc<ResultSet> pFctApp) throws Exception {
        Rdb rz = null;
        if (IRdb.class.getSimpleName().equals(pBnNm)) {
            rz = this.crPuRdb(pRqVs, pFctApp);
        }
        return rz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release(Map<String, Object> pRqVs, FctBlc<ResultSet> pFctApp) throws Exception {
        if (this.ds != null) {
            pFctApp.lazLogStd(null).info(pRqVs, this.getClass(), "Try to close DS...");
            try {
                this.ds.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.ds = null;
            }
        }
    }

    private Rdb crPuRdb(Map<String, Object> pRqVs, FctBlc<ResultSet> pFctApp) throws Exception {
        Rdb rdb = new Rdb();
        rdb.setLog(pFctApp.lazLogStd(pRqVs));
        rdb.setSrvClVl(pFctApp.lazSrvClVl(pRqVs));
        this.ds = new HikariDataSource();
        this.ds.setJdbcUrl(pFctApp.getFctDt().getDbUrl());
        this.ds.setDriverClassName(pFctApp.getFctDt().getDbCls());
        rdb.setDs((DataSource)this.ds);
        pFctApp.put(pRqVs, IRdb.class.getSimpleName(), rdb);
        pFctApp.lazLogStd(pRqVs).info(pRqVs, this.getClass(), IRdb.class.getSimpleName() + " has been created");
        return rdb;
    }
}

