/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.jdbc.RecSet;
import org.beigesoft.mdl.ColVals;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.rdb.ARdb;
import org.beigesoft.rdb.SrvClVl;

public class Rdb
extends ARdb<ResultSet> {
    private SrvClVl srvClVl;
    private DataSource ds;
    private static final ThreadLocal<Connection> HLDCON = new ThreadLocal<Connection>(){};
    private static final ThreadLocal<Map<String, Savepoint>> HLDAVPS = new ThreadLocal<Map<String, Savepoint>>(){};

    @Override
    public final boolean getAcmt() throws Exception {
        return this.lazCon().getAutoCommit();
    }

    @Override
    public final void setAcmt(boolean pAcmt) throws Exception {
        this.lazCon().setAutoCommit(pAcmt);
    }

    @Override
    public final void setTrIsl(int pLevel) throws Exception {
        if (pLevel != 2 && pLevel != 1 && pLevel != 4 && pLevel != 8) {
            throw new ExcCode(1002, "Transaction isolation not supported# " + pLevel);
        }
        this.lazCon().setTransactionIsolation(pLevel);
    }

    @Override
    public final int getTrIsl() throws Exception {
        return this.lazCon().getTransactionIsolation();
    }

    @Override
    public final void creSavPnt(String pSpNm) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8000);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", create SP " + pSpNm);
        }
        Savepoint sp = this.lazCon().setSavepoint(pSpNm);
        this.lazSvps().put(pSpNm, sp);
    }

    @Override
    public final void relSavPnt(String pSpNm) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8001);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", release SP " + pSpNm);
        }
        Map<String, Savepoint> svps = this.lazSvps();
        this.lazCon().releaseSavepoint(svps.get(pSpNm));
        this.lazSvps().remove(pSpNm);
    }

    @Override
    public final void rollBack(String pSpNm) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8002);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", roll back to " + pSpNm);
        }
        Map<String, Savepoint> svps = this.lazSvps();
        this.lazCon().rollback(svps.get(pSpNm));
        svps.remove(pSpNm);
    }

    @Override
    public final void begin() throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8003);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", start.");
        }
        this.lazCon();
    }

    @Override
    public final void commit() throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8004);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", commit.");
        }
        this.lazCon().commit();
    }

    @Override
    public final void rollBack() throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8005);
        if (dbgSh) {
            this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", roll back!");
        }
        this.lazCon().rollback();
    }

    @Override
    public final IRecSet<ResultSet> retRs(String pSel) throws Exception {
        try {
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8006);
            if (dbgSh) {
                this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", try to execute: " + pSel);
            }
            Statement stmt = this.lazCon().createStatement();
            ResultSet rs = stmt.executeQuery(pSel);
            return new RecSet(rs, stmt);
        }
        catch (SQLException sqle) {
            String msg = sqle.getMessage() + ", RDBMS error code " + sqle.getErrorCode() + ", qu:\n" + pSel;
            throw new ExcCode(1154, msg);
        }
    }

    @Override
    public final void exec(String pQu) throws Exception {
        try (Statement stmt = null;){
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8007);
            if (dbgSh) {
                this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", try to execute: " + pQu);
            }
            stmt = this.lazCon().createStatement();
            stmt.executeUpdate(pQu);
        }
    }

    @Override
    public final <T extends IHasId<?>> int update(Class<T> pCls, ColVals pCv, String pWhe) throws Exception {
        String qu = this.getSrvClVl().evUpdateCnd(pCls, pCv, pWhe);
        try (Statement stmt = null;){
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8008);
            if (dbgSh) {
                this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", try to execute update: " + qu);
            }
            stmt = this.lazCon().createStatement();
            int n = stmt.executeUpdate(qu);
            return n;
        }
    }

    @Override
    public final <T extends IHasId<?>> long insert(Class<T> pCls, ColVals pCv) throws Exception {
        String qu = this.getSrvClVl().evInsert(pCls, pCv);
        try (Statement stmt = null;){
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8009);
            if (dbgSh) {
                this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", try to execute insert: " + qu);
            }
            stmt = this.lazCon().createStatement();
            long l = stmt.executeUpdate(qu);
            return l;
        }
    }

    @Override
    public final int delete(String pTbl, String pWhe) throws Exception {
        Statement stmt = null;
        String strWhe = "";
        if (pWhe != null) {
            strWhe = " where " + pWhe;
        }
        String qu = "delete from " + pTbl + strWhe + ";";
        try {
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 8010);
            if (dbgSh) {
                this.getLog().debug(null, this.getClass(), "Thread ID=" + Thread.currentThread().getId() + ", try to execute delete: " + qu);
            }
            stmt = this.lazCon().createStatement();
            int n = stmt.executeUpdate(qu);
            return n;
        }
        catch (SQLException sqle) {
            String msg = sqle.getMessage() + ", RDBMS error code " + sqle.getErrorCode() + ", qu:\n" + qu;
            throw new ExcCode(1154, msg);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public final void release() throws Exception {
        Connection con = HLDCON.get();
        if (con != null) {
            con.setAutoCommit(true);
            con.close();
            HLDCON.set(null);
        }
    }

    public final Connection lazCon() throws Exception {
        Connection con = HLDCON.get();
        if (con == null) {
            con = this.ds.getConnection();
            HLDCON.set(con);
        }
        return con;
    }

    public final Map<String, Savepoint> lazSvps() throws Exception {
        Map<String, Savepoint> svps = HLDAVPS.get();
        if (svps == null) {
            svps = new HashMap<String, Savepoint>();
            HLDAVPS.set(svps);
        }
        return svps;
    }

    public final SrvClVl getSrvClVl() {
        return this.srvClVl;
    }

    public final void setSrvClVl(SrvClVl pSrvClVl) {
        this.srvClVl = pSrvClVl;
    }

    public final DataSource getDs() {
        return this.ds;
    }

    public final void setDs(DataSource pDs) {
        this.ds = pDs;
    }
}

