/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.prc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.IHlNmClMt;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.IOrId;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;

public class PrcEnfSv<T extends IHasId<ID>, ID>
implements IPrcEnt<T, ID> {
    private IOrm orm;
    private IHlNmClMt hldSets;
    private IHlNmClMt hldGets;
    private String uplDir;
    private String appPth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T process(Map<String, Object> pRvs, T pEnt, IReqDt pRqDt) throws Exception {
        IOrId oid;
        if (!pEnt.getIsNew().booleanValue() && IOrId.class.isAssignableFrom(pEnt.getClass()) && !(oid = (IOrId)pEnt).getDbOr().equals(this.orm.getDbId())) {
            throw new ExcCode(1001, "can_not_change_foreign_src");
        }
        HashMap<String, Object> vs = new HashMap<String, Object>();
        String fileUplNm = (String)pRqDt.getAttr("fileUplNm");
        String fdFlPth = pRqDt.getParam("fdFlPth");
        String fdFlNm = pRqDt.getParam("fdFlNm");
        if (fdFlNm != null) {
            Method sfn = this.hldSets.get(pEnt.getClass(), fdFlNm);
            if (fileUplNm != null) {
                sfn.invoke(pEnt, fileUplNm);
            } else {
                Method getFpn = this.hldGets.get(pEnt.getClass(), fdFlPth);
                String pth = (String)getFpn.invoke(pEnt, new Object[0]);
                if (pth == null || "".equals(pth)) {
                    sfn.invoke(pEnt, null);
                } else {
                    int idxs = pth.lastIndexOf("/");
                    if (idxs > 1) {
                        sfn.invoke(pEnt, pth.substring(idxs + 1));
                    } else {
                        sfn.invoke(pEnt, pth);
                    }
                }
            }
        }
        if (fileUplNm != null) {
            OutputStream outs = null;
            InputStream ins = null;
            try {
                int count;
                String ft = String.valueOf(new Date().getTime());
                String filePath = this.appPth + File.separator + this.uplDir + File.separator + ft + fileUplNm;
                ins = (InputStream)pRqDt.getAttr("fileUplIs");
                outs = new BufferedOutputStream(new FileOutputStream(filePath));
                byte[] data = new byte[1024];
                while ((count = ins.read(data)) != -1) {
                    outs.write(data, 0, count);
                }
                outs.flush();
                Method sfp = this.hldSets.get(pEnt.getClass(), fdFlPth);
                sfp.invoke(pEnt, filePath);
                String fdFlUrl = pRqDt.getParam("fdFlUrl");
                if (fdFlUrl != null) {
                    Method sfu = this.hldSets.get(pEnt.getClass(), fdFlUrl);
                    sfu.invoke(pEnt, this.uplDir + "/" + ft + fileUplNm);
                }
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
                if (outs != null) {
                    outs.close();
                }
            }
        }
        if (pEnt.getIsNew().booleanValue()) {
            this.orm.insert(pRvs, (Map<String, Object>)vs, pEnt);
            pRvs.put("msgSuc", "insert_ok");
        } else {
            this.orm.update(pRvs, (Map<String, Object>)vs, pEnt);
            pRvs.put("msgSuc", "update_ok");
        }
        return pEnt;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IHlNmClMt getHldSets() {
        return this.hldSets;
    }

    public final void setHldSets(IHlNmClMt pHldSets) {
        this.hldSets = pHldSets;
    }

    public final IHlNmClMt getHldGets() {
        return this.hldGets;
    }

    public final void setHldGets(IHlNmClMt pHldGets) {
        this.hldGets = pHldGets;
    }

    public final String getUplDir() {
        return this.uplDir;
    }

    public final void setUplDir(String pUplDir) {
        this.uplDir = pUplDir;
    }

    public final String getAppPth() {
        return this.appPth;
    }

    public final void setAppPth(String pAppPth) {
        this.appPth = pAppPth;
    }
}

