/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rdb;

import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.mdlp.DbInf;
import org.beigesoft.rdb.IRdb;

public abstract class ARdb<RS>
implements IRdb<RS> {
    private DbInf dbInf;
    private ILog log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer evInt(String pQu, String pClNm) throws Exception {
        Integer result = null;
        try (IRecSet rs = null;){
            rs = this.retRs(pQu);
            if (rs.first()) {
                result = rs.getInt(pClNm);
                if (rs.next()) {
                    throw new ExcCode(1001, "Query returns more than 1 result - " + pQu);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Long evLong(String pQu, String pClNm) throws Exception {
        Long result = null;
        try (IRecSet rs = null;){
            rs = this.retRs(pQu);
            if (rs.first()) {
                result = rs.getLong(pClNm);
                if (rs.next()) {
                    throw new ExcCode(1001, "Query returns more than 1 result - " + pQu);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Float evFloat(String pQu, String pClNm) throws Exception {
        Float result = null;
        try (IRecSet rs = null;){
            rs = this.retRs(pQu);
            if (rs.first()) {
                result = rs.getFloat(pClNm);
                if (rs.next()) {
                    throw new ExcCode(1001, "Query returns more than 1 result - " + pQu);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Double evDouble(String pQu, String pClNm) throws Exception {
        Double result = null;
        try (IRecSet rs = null;){
            rs = this.retRs(pQu);
            if (rs.first()) {
                result = rs.getDouble(pClNm);
                if (rs.next()) {
                    throw new ExcCode(1001, "Query returns more than 1 result - " + pQu);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Double[] evDoubles(String pQu, String[] pClNms) throws Exception {
        Double[] result = new Double[pClNms.length];
        try (IRecSet rs = null;){
            rs = this.retRs(pQu);
            if (rs.first()) {
                for (int i = 0; i < pClNms.length; ++i) {
                    result[i] = rs.getDouble(pClNms[i]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized DbInf getDbInf() throws Exception {
        if (this.dbInf == null) {
            try (IRecSet rs = null;){
                String qu = "select DBID, DBVR, INF from DBINF;";
                DbInf di = new DbInf();
                rs = this.retRs(qu);
                if (rs.first()) {
                    di.setDbId(rs.getInt("DBID"));
                    di.setDbVr(rs.getInt("DBVR"));
                    di.setInf(rs.getStr("INF"));
                    if (rs.next()) {
                        throw new ExcCode(1002, "Wrong DB info!");
                    }
                } else {
                    throw new ExcCode(1002, "Wrong DB info!");
                }
                this.dbInf = di;
            }
        }
        return this.dbInf;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }
}

