/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rpl;

import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beigesoft.dlg.IMake;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.prp.ISetng;
import org.beigesoft.rdb.IRdb;

public class ClrDb<RS>
implements IMake {
    private ISetng setng;
    private IRdb<RS> rdb;
    private ILog log;

    @Override
    public final void make(Map<String, Object> pRvs) throws Exception {
        List<Class<IHasId<?>>> clss = this.setng.lazClss();
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(IRdb.TRRUC);
            this.rdb.begin();
            this.log.info(pRvs, ClrDb.class, "Start clear database.");
            for (int i = clss.size() - 1; i >= 0; --i) {
                Class<IHasId<?>> cls = clss.get(i);
                this.rdb.delete(cls.getSimpleName().toUpperCase(), null);
            }
            this.rdb.commit();
            Writer wri = (Writer)pRvs.get("htmWri");
            if (wri != null) {
                wri.write("<h4>" + new Date().toString() + ", " + ClrDb.class.getSimpleName() + ", database has been cleared</h4>");
            }
            this.log.info(pRvs, ClrDb.class, "Finish clear database.");
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    public final ISetng getSetng() {
        return this.setng;
    }

    public final void setSetng(ISetng pSetng) {
        this.setng = pSetng;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }
}

