/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rpl;

import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beigesoft.dlg.IMake;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdlp.IOrId;
import org.beigesoft.prp.ISetng;
import org.beigesoft.rdb.IRdb;

public class PsgAft<RS>
implements IMake {
    private ISetng setng;
    private IRdb<RS> rdb;
    private ILog log;

    @Override
    public final void make(Map<String, Object> pRvs) throws Exception {
        List<Class<IHasId<?>>> clss = this.setng.lazClss();
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(IRdb.TRRUC);
            this.rdb.begin();
            this.log.info(pRvs, PsgAft.class, "Start refresh sequences auto-ID...");
            int rfrc = 0;
            for (int i = clss.size() - 1; i >= 0; --i) {
                Class<IHasId<?>> cls = clss.get(i);
                if (!IOrId.class.isAssignableFrom(cls)) continue;
                ++rfrc;
                String queryMaxId = "select max(IID) as MAXID from " + cls.getSimpleName().toUpperCase() + ";";
                Integer maxId = this.rdb.evInt(queryMaxId, "MAXID");
                if (maxId == null) continue;
                Integer n = maxId;
                Integer n2 = maxId = Integer.valueOf(maxId + 1);
                String querySec = "alter sequence " + cls.getSimpleName().toUpperCase() + "_IID_SEQ restart with " + maxId + ";";
                this.rdb.exec(querySec);
            }
            this.rdb.commit();
            Writer wri = (Writer)pRvs.get("htmWri");
            if (wri != null) {
                wri.write("<h4>" + new Date().toString() + ", " + PsgAft.class.getSimpleName() + ", total refreshed ID sequences " + rfrc + "</h4>");
            }
            this.log.info(pRvs, PsgAft.class, "Finish refreshing sequences auto-ID.");
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    public final ISetng getSetng() {
        return this.setng;
    }

    public final void setSetng(ISetng pSetng) {
        this.setng = pSetng;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }
}

