/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rpl;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.cnv.IFilFldStr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.fct.IFcFlFdSt;
import org.beigesoft.hld.IHlNmClSt;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.prp.ISetng;
import org.beigesoft.rpl.IRpEntRead;
import org.beigesoft.srv.IUtlXml;

public class RpEntReadXml
implements IRpEntRead<IHasId<?>> {
    private ILog log;
    private ISetng setng;
    private IHlNmClSt hldFilFdNms;
    private IFcFlFdSt fctFilFld;
    private IUtlXml utlXml;

    @Override
    public final IHasId<?> read(Map<String, Object> pRvs, Reader pReader) throws Exception {
        IFilFldStr filFl;
        String filFdNm;
        Map<String, String> attrs = this.utlXml.readAttrs(pRvs, pReader);
        if (attrs.get("class") == null) {
            throw new ExcCode(1002, "There is no class attribute for entity!");
        }
        Class<?> cls = Class.forName(attrs.get("class"));
        Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
        IHasId ent = (IHasId)constructor.newInstance(new Object[0]);
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 6600);
        HashMap<String, Object> vs = new HashMap<String, Object>();
        if (dbgSh) {
            this.log.debug(pRvs, RpEntReadXml.class, "Filling entity from XML: " + cls);
        }
        for (String flNm : this.setng.lazIdFldNms(cls)) {
            filFdNm = this.hldFilFdNms.get(cls, flNm);
            filFl = this.fctFilFld.laz(pRvs, filFdNm);
            filFl.fill(pRvs, vs, ent, flNm, attrs.get(flNm));
        }
        for (String flNm : this.setng.lazFldNms(cls)) {
            filFdNm = this.hldFilFdNms.get(cls, flNm);
            filFl = this.fctFilFld.laz(pRvs, filFdNm);
            filFl.fill(pRvs, vs, ent, flNm, attrs.get(flNm));
        }
        return ent;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final ISetng getSetng() {
        return this.setng;
    }

    public final void setSetng(ISetng pSetng) {
        this.setng = pSetng;
    }

    public final IHlNmClSt getHldFilFdNms() {
        return this.hldFilFdNms;
    }

    public final void setHldFilFdNms(IHlNmClSt pHldFilFdNms) {
        this.hldFilFdNms = pHldFilFdNms;
    }

    public final IFcFlFdSt getFctFilFld() {
        return this.fctFilFld;
    }

    public final void setFctFilFld(IFcFlFdSt pFctFilFld) {
        this.fctFilFld = pFctFilFld;
    }

    public final IUtlXml getUtlXml() {
        return this.utlXml;
    }

    public final void setUtlXml(IUtlXml pUtlXml) {
        this.utlXml = pUtlXml;
    }
}

