/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rpl;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdlp.DbInf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rpl.IRpEntWri;
import org.beigesoft.rpl.IRpRtrv;

public class RpRtrvDbXml<RS>
implements IRpRtrv {
    private IRpEntWri rpEntWri;
    private ILog log;
    private IOrm orm;
    private IRdb<RS> rdb;
    private Integer readTi;

    @Override
    public final <T extends IHasId<?>> int rtrvTo(Map<String, Object> pRvs, Class<T> pCls, Writer pWri) throws Exception {
        String cond = (String)pRvs.get("cond");
        int dsDbVr = Integer.parseInt((String)pRvs.get("dsDbVr"));
        List<T> entities = null;
        int entCnt = 0;
        DbInf di = this.rdb.getDbInf();
        if (dsDbVr == di.getDbVr()) {
            try {
                int srDbId;
                this.rdb.setAcmt(false);
                this.rdb.setTrIsl(this.readTi);
                this.rdb.begin();
                String srDbIdStr = (String)pRvs.get("srDbId");
                if (srDbIdStr != null && (srDbId = Integer.parseInt(srDbIdStr)) != di.getDbId()) {
                    String error = "Different requested database ID! required/is: " + srDbId + "/" + di.getDbId();
                    this.log.error(pRvs, RpRtrvDbXml.class, error);
                    pWri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    pWri.write("<message error=\"" + error + "\">\n");
                    pWri.write("</message>\n");
                    int n = entCnt;
                    return n;
                }
                HashMap<String, Object> vs = new HashMap<String, Object>();
                vs.put(pCls.getSimpleName() + "dpLv", 1);
                entities = cond == null ? this.getOrm().retLst(pRvs, vs, pCls) : this.getOrm().retLstCnd(pRvs, vs, pCls, cond);
                entCnt = entities.size();
                this.rdb.commit();
            }
            catch (Exception ex) {
                if (!this.rdb.getAcmt()) {
                    this.rdb.rollBack();
                }
                throw ex;
            }
            finally {
                this.rdb.release();
            }
            this.log.info(pRvs, RpRtrvDbXml.class, "Start write entities of " + pCls.getCanonicalName() + " count=" + entCnt);
            pWri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pWri.write("<message databaseId=\"" + di.getDbId() + "\" dbVr=\"" + di.getDbVr() + "\" description=\"" + di.getInf() + "\" entCnt=\"" + entCnt + "\">\n");
            for (IHasId entity : entities) {
                this.rpEntWri.write(pRvs, entity, pWri);
            }
            pWri.write("</message>\n");
            this.log.info(pRvs, RpRtrvDbXml.class, "Entities has been wrote");
        } else {
            this.log.error(pRvs, RpRtrvDbXml.class, "Send error message - Different database version!");
            pWri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pWri.write("<message error=\"Different database version!\">\n");
            pWri.write("</message>\n");
        }
        return entCnt;
    }

    public final IRpEntWri getRpEntWri() {
        return this.rpEntWri;
    }

    public final void setRpEntWri(IRpEntWri pRpEntWri) {
        this.rpEntWri = pRpEntWri;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getReadTi() {
        return this.readTi;
    }

    public final void setReadTi(Integer pReadTi) {
        this.readTi = pReadTi;
    }
}

