/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.rpl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.beigesoft.dlg.IMake;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdlp.DbInf;
import org.beigesoft.prp.ISetng;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rpl.IFctFltEnt;
import org.beigesoft.rpl.IFltEnts;
import org.beigesoft.rpl.IReplicator;
import org.beigesoft.rpl.IRpStor;
import org.beigesoft.srv.IUtlXml;

public class RplXmlHttps<RS>
implements IReplicator {
    private ISetng setng;
    private IRpStor rpStor;
    private IRdb<RS> rdb;
    private ILog log;
    private IMake dbBefore;
    private IMake dbAfter;
    private IUtlXml utlXml;
    private IFctFltEnt fctFltEnts;

    @Override
    public final void replicate(Map<String, Object> pRvs) throws Exception {
        Writer wri = (Writer)pRvs.get("htmWri");
        try {
            String urlSrcStr = "https://" + (String)pRvs.get("urlSrc");
            if (urlSrcStr == null || urlSrcStr.length() < 10) {
                throw new ExcCode(1003, "Where_is_no_urlSrc");
            }
            this.log.info(pRvs, this.getClass(), "URL source: " + urlSrcStr);
            URL url = new URL(urlSrcStr);
            String auMt = (String)pRvs.get("auMt");
            if ("base".equals(auMt)) {
                final String usr = (String)pRvs.get("usr");
                final String pwd = (String)pRvs.get("pwd");
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(usr, pwd.toCharArray());
                    }
                });
            } else if ("form".equals(auMt)) {
                CookieManager coMng = new CookieManager();
                CookieHandler.setDefault(coMng);
                coMng.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                this.reqCookies(pRvs);
                this.authForm(pRvs, coMng);
            }
            Map<String, Integer> clsCnts = this.makeJob(url, pRvs);
            if (wri != null) {
                String statusString = ", replication has been done.";
                wri.write("<h4>" + new Date().toString() + statusString + "</h4>");
                pRvs.put("statusString", new Date().toString() + ", " + RplXmlHttps.class.getSimpleName() + statusString);
                this.log.info(null, RplXmlHttps.class, statusString);
                wri.write("<table>");
                wri.write("<tr><th style=\"padding: 5px;\">Class</th><th style=\"padding: 5px;\">Total records</th></tr>");
                for (Map.Entry<String, Integer> entry : clsCnts.entrySet()) {
                    wri.write("<tr>");
                    wri.write("<td>" + entry.getKey() + "</td>");
                    wri.write("<td>" + entry.getValue() + "</td>");
                    wri.write("</tr>");
                }
                wri.write("</table>");
            }
        }
        catch (ExcCode ex) {
            if (wri != null) {
                wri.write(new Date().toString() + ", " + RplXmlHttps.class.getSimpleName() + ", " + ex.getMessage());
            }
            throw ex;
        }
        pRvs.remove("cooks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Integer> makeJob(URL pUrl, Map<String, Object> pRvs) throws Exception {
        String srDbId = (String)pRvs.get("srDbId");
        String maxRecsStr = (String)pRvs.get("maxRecs");
        if (maxRecsStr == null || maxRecsStr.length() == 0) {
            throw new ExcCode(1003, "WhereisnomaxRecs");
        }
        int maxRecs = Integer.parseInt(maxRecsStr);
        LinkedHashMap<String, Integer> clsCnts = new LinkedHashMap<String, Integer>();
        Integer clsCnt = 0;
        boolean isDbBefore = false;
        DbInf dbInf = this.rdb.getDbInf();
        for (Class<IHasId<?>> cls : this.setng.lazClss()) {
            int entRecd = 0;
            int fstRec = 0;
            do {
                HttpsURLConnection urlCn = (HttpsURLConnection)pUrl.openConnection();
                if (!pUrl.getHost().equals(urlCn.getURL().getHost())) {
                    throw new ExcCode(1001, "You should sign-in in browser first!");
                }
                OutputStreamWriter writer = null;
                BufferedReader reader = null;
                try {
                    IFltEnts fltEnts;
                    String cnd;
                    urlCn.setDoOutput(true);
                    urlCn.setRequestMethod("POST");
                    String cooks = (String)pRvs.get("cooks");
                    if (cooks != null) {
                        urlCn.addRequestProperty("Cookie", cooks);
                    }
                    writer = new OutputStreamWriter(urlCn.getOutputStream(), Charset.forName("UTF-8").newEncoder());
                    String fltEntNm = this.setng.lazClsStg(cls, "fltEnt");
                    String cond = "";
                    if (fltEntNm != null && (cnd = (fltEnts = this.fctFltEnts.laz(pRvs, fltEntNm)).makeWhe(pRvs, cls)) != null) {
                        cond = " where " + cnd;
                    }
                    cond = cond + " limit " + maxRecs + " offset " + fstRec;
                    String srDbIdStr = "";
                    if (srDbId != null) {
                        if (Integer.parseInt(srDbId) == dbInf.getDbId()) {
                            throw new ExcCode(1003, "requested_database_must_be_different");
                        }
                        srDbIdStr = "&srDbId=" + srDbId;
                    }
                    writer.write("ent=" + cls.getCanonicalName() + "&cond=" + cond + "&dsDbVr=" + dbInf.getDbVr() + srDbIdStr);
                    writer.write("&prc=" + pRvs.get("prc"));
                    writer.flush();
                    if (200 == urlCn.getResponseCode()) {
                        reader = new BufferedReader(new InputStreamReader(urlCn.getInputStream(), Charset.forName("UTF-8").newDecoder()));
                        if (!this.utlXml.readUntilStart(reader, "message")) {
                            throw new ExcCode(1001, "Wrong XML response without message tag!!!");
                        }
                        Map<String, String> msgAttrs = this.utlXml.readAttrs(pRvs, reader);
                        String error = msgAttrs.get("error");
                        if (error != null) {
                            throw new ExcCode(1001, error);
                        }
                        String entCntStr = msgAttrs.get("entCnt");
                        if (entCntStr == null) {
                            throw new ExcCode(1001, "Wrong XML response without entCnt in message!!!");
                        }
                        entRecd = Integer.parseInt(entCntStr);
                        if (entRecd > 0) {
                            clsCnt = clsCnt + entRecd;
                            this.log.info(null, RplXmlHttps.class, "Try to parse entities total: " + entRecd + " of " + cls.getCanonicalName());
                            if (!isDbBefore) {
                                if (this.dbBefore != null) {
                                    this.dbBefore.make(pRvs);
                                }
                                isDbBefore = true;
                            }
                            this.rpStor.storeFr(pRvs, reader);
                            if (entRecd == maxRecs) {
                                fstRec += maxRecs;
                            } else {
                                fstRec = 0;
                                entRecd = 0;
                            }
                        } else {
                            fstRec = 0;
                        }
                        continue;
                    }
                    throw new ExcCode(1001, "Can't receive data!!! Response code=" + urlCn.getResponseCode());
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    urlCn.disconnect();
                }
            } while (entRecd > 0);
            clsCnts.put(cls.getCanonicalName(), clsCnt);
            clsCnt = 0;
        }
        if (this.dbAfter != null) {
            this.dbAfter.make(pRvs);
        }
        return clsCnts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reqCookies(Map<String, Object> pRvs) throws Exception {
        block11: {
            String urlGetAuthCookStr = (String)pRvs.get("urlAuCo");
            URL urlAuCo = new URL(urlGetAuthCookStr);
            HttpsURLConnection urlCn = null;
            BufferedReader reader = null;
            try {
                urlCn = (HttpsURLConnection)urlAuCo.openConnection();
                urlCn.setRequestMethod("GET");
                urlCn.addRequestProperty("Connection", "keep-alive");
                if (200 == urlCn.getResponseCode()) {
                    reader = new BufferedReader(new InputStreamReader(urlCn.getInputStream(), Charset.forName("UTF-8").newDecoder()));
                    while (reader.read() != -1) {
                    }
                    break block11;
                }
                throw new ExcCode(1001, "reqCookies Can't receive data!!! Response code=" + urlCn.getResponseCode());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (urlCn != null) {
                    urlCn.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void authForm(Map<String, Object> pRvs, CookieManager pCoMng) throws Exception {
        String auUrl = (String)pRvs.get("auUrl");
        String auUsr = (String)pRvs.get("auUsr");
        String auPwd = (String)pRvs.get("auPwd");
        String usr = (String)pRvs.get("usr");
        String pwd = (String)pRvs.get("pwd");
        URL url = new URL(auUrl);
        HttpsURLConnection urlCn = (HttpsURLConnection)url.openConnection();
        if (!url.getHost().equals(urlCn.getURL().getHost())) {
            throw new ExcCode(1001, "You should sign-in in browser first!");
        }
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        try {
            urlCn.setDoOutput(true);
            urlCn.setRequestMethod("POST");
            String paramStr = auUsr + "=" + usr + "&" + auPwd + "=" + pwd;
            StringBuffer cookiesSb = new StringBuffer();
            for (HttpCookie cookie : pCoMng.getCookieStore().getCookies()) {
                cookiesSb.append(cookie.getName() + "=" + cookie.getValue() + ";");
            }
            String cooks = cookiesSb.toString();
            pRvs.put("cooks", cooks);
            urlCn.addRequestProperty("Cookie", cooks);
            urlCn.addRequestProperty("Connection", "keep-alive");
            urlCn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlCn.addRequestProperty("Content-Length", String.valueOf(paramStr.length()));
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 6500);
            if (dbgSh) {
                this.getLog().debug(pRvs, RplXmlHttps.class, "Request before flush auth:");
                for (Map.Entry<String, List<String>> entry : urlCn.getRequestProperties().entrySet()) {
                    this.log.debug(pRvs, RplXmlHttps.class, "  Request entry key: " + entry.getKey());
                    for (String val : entry.getValue()) {
                        this.log.debug(pRvs, RplXmlHttps.class, "   Request entry value: " + val);
                    }
                }
            }
            writer = new OutputStreamWriter(urlCn.getOutputStream(), Charset.forName("UTF-8").newEncoder());
            writer.write(paramStr);
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(urlCn.getInputStream(), Charset.forName("UTF-8").newDecoder()));
            while (reader.read() != -1) {
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            urlCn.disconnect();
        }
    }

    public final ISetng getSetng() {
        return this.setng;
    }

    public final void setSetng(ISetng pSetng) {
        this.setng = pSetng;
    }

    public final IRpStor getRpStor() {
        return this.rpStor;
    }

    public final void setRpStor(IRpStor pRpStor) {
        this.rpStor = pRpStor;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IMake getDbBefore() {
        return this.dbBefore;
    }

    public final void setDbBefore(IMake pDbBefore) {
        this.dbBefore = pDbBefore;
    }

    public final IMake getDbAfter() {
        return this.dbAfter;
    }

    public final void setDbAfter(IMake pDbAfter) {
        this.dbAfter = pDbAfter;
    }

    public final IUtlXml getUtlXml() {
        return this.utlXml;
    }

    public final void setUtlXml(IUtlXml pUtlXml) {
        this.utlXml = pUtlXml;
    }

    public final IFctFltEnt getFctFltEnts() {
        return this.fctFltEnts;
    }

    public final void setFctFltEnts(IFctFltEnt pFctFltEnts) {
        this.fctFltEnts = pFctFltEnts;
    }
}

