/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.srv;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.cmp.CmpCsvCol;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.IHlMaFrn;
import org.beigesoft.mdl.ECsvClTy;
import org.beigesoft.mdlp.CsvCl;
import org.beigesoft.mdlp.CsvMth;
import org.beigesoft.mdlp.MaFrn;
import org.beigesoft.mdlp.MaFrnLn;
import org.beigesoft.srv.ICsvWri;
import org.beigesoft.srv.INumStr;
import org.beigesoft.srv.IReflect;

public class CsvWri
implements ICsvWri {
    private IReflect reflect;
    private INumStr numStr;
    private IHlMaFrn hlMaFrn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(Map<String, Object> pRqVs, List<List<Object>> pData, CsvMth pCsMh, OutputStream pOus) throws Exception {
        int i;
        HashMap<Long, MaFrn> mfMap = new HashMap<Long, MaFrn>();
        HashMap<Integer, SimpleDateFormat> dtFrmts = new HashMap<Integer, SimpleDateFormat>();
        HashMap<Integer, String[]> numSps = new HashMap<Integer, String[]>();
        for (CsvCl col : pCsMh.getClns()) {
            if (col.getFrmt() == null) continue;
            if (col.getTyp().equals((Object)ECsvClTy.DATE)) {
                try {
                    dtFrmts.put(col.getIndx(), new SimpleDateFormat(col.getFrmt()));
                    continue;
                }
                catch (Exception ee) {
                    throw new ExcCode(1002, "Wrong date format! Format: " + col.getFrmt(), ee);
                }
            }
            if (!col.getTyp().equals((Object)ECsvClTy.NUMERIC)) continue;
            String[] seps = null;
            try {
                seps = col.getFrmt().split(",");
                for (i = 0; i < 2; ++i) {
                    if ("SPACE".equals(seps[i])) {
                        seps[i] = "\u00a0";
                        continue;
                    }
                    if (!"COMMA".equals(seps[i])) continue;
                    seps[i] = ",";
                }
                numSps.put(col.getIndx(), seps);
            }
            catch (Exception ee) {
                throw new ExcCode(1002, "Wrong amount format! Format: " + col.getFrmt(), ee);
            }
        }
        Collections.sort(pCsMh.getClns(), new CmpCsvCol());
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter(pOus, Charset.forName(pCsMh.getChrst()).newEncoder());
            if (pCsMh.getHasHd().booleanValue()) {
                for (int i2 = 0; i2 < pCsMh.getClns().size(); ++i2) {
                    if (i2 == 0) {
                        writer.write(pCsMh.getClns().get(i2).getNme());
                        continue;
                    }
                    if (i2 == pCsMh.getClns().size() - 1) {
                        writer.write(pCsMh.getClSp() + pCsMh.getClns().get(i2).getNme() + "\r\n");
                        continue;
                    }
                    writer.write(pCsMh.getClSp() + pCsMh.getClns().get(i2).getNme());
                }
            }
            for (List<Object> row : pData) {
                for (i = 0; i < pCsMh.getClns().size(); ++i) {
                    String clVl = "";
                    if (pCsMh.getClns().get(i).getCnst() != null) {
                        clVl = pCsMh.getClns().get(i).getCnst();
                    } else if (pCsMh.getClns().get(i).getDtIdx() != null && row.get(pCsMh.getClns().get(i).getDtIdx() - 1) != null) {
                        Object obVl = null;
                        if (pCsMh.getClns().get(i).getFldPh() == null) {
                            obVl = row.get(pCsMh.getClns().get(i).getDtIdx() - 1);
                        } else {
                            Method getter;
                            String[] fpa = pCsMh.getClns().get(i).getFldPh().split(",");
                            Object ent = row.get(pCsMh.getClns().get(i).getDtIdx() - 1);
                            for (int j = 0; j < fpa.length && (ent = (obVl = (getter = this.reflect.retGet(ent.getClass(), fpa[j])).invoke(ent, new Object[0]))) != null; ++j) {
                            }
                        }
                        if (obVl != null) {
                            if (pCsMh.getClns().get(i).getFrmt() == null) {
                                if (pCsMh.getClns().get(i).getMaFrn() != null) {
                                    MaFrn mf = (MaFrn)mfMap.get(pCsMh.getClns().get(i).getMaFrn().getIid());
                                    if (mf == null) {
                                        mf = this.hlMaFrn.get(pRqVs, pCsMh.getClns().get(i).getMaFrn().getIid());
                                        if (mf == null) {
                                            throw new ExcCode(1001, "Can't find match foreign ID: " + pCsMh.getClns().get(i).getMaFrn().getIid());
                                        }
                                        mfMap.put(pCsMh.getClns().get(i).getMaFrn().getIid(), mf);
                                    }
                                    String natVal = obVl.toString();
                                    for (MaFrnLn mfl : mf.getLns()) {
                                        if (!natVal.equals(mfl.getNtvVl())) continue;
                                        clVl = mfl.getFrnVl();
                                        break;
                                    }
                                } else {
                                    clVl = obVl.toString();
                                }
                            } else if (pCsMh.getClns().get(i).getTyp().equals((Object)ECsvClTy.DATE)) {
                                clVl = ((SimpleDateFormat)dtFrmts.get(pCsMh.getClns().get(i).getIndx())).format((Date)obVl);
                            } else if (pCsMh.getClns().get(i).getTyp().equals((Object)ECsvClTy.NUMERIC)) {
                                String[] sps = (String[])numSps.get(pCsMh.getClns().get(i).getIndx());
                                Integer scl = null;
                                if (sps.length == 3) {
                                    scl = Integer.parseInt(sps[2]);
                                }
                                BigDecimal bdv = (BigDecimal)obVl;
                                if (scl == null) {
                                    scl = bdv.scale();
                                } else {
                                    bdv = bdv.setScale((int)scl, RoundingMode.HALF_UP);
                                }
                                clVl = this.numStr.frmt(obVl.toString(), sps[0], sps[1], scl);
                            } else if (pCsMh.getClns().get(i).getTyp().equals((Object)ECsvClTy.BOOLEAN)) {
                                String[] frm = pCsMh.getClns().get(i).getFrmt().split(",");
                                Boolean blv = (Boolean)obVl;
                                clVl = blv.booleanValue() ? frm[0] : frm[1];
                            } else {
                                throw new ExcCode(1002, "data_format_not_yet_implemented");
                            }
                        }
                    }
                    if (pCsMh.getClns().get(i).getTxDlm() != null && !"".equals(clVl)) {
                        clVl = pCsMh.getClns().get(i).getTxDlm() + clVl + pCsMh.getClns().get(i).getTxDlm();
                    }
                    if (i == 0) {
                        writer.write(clVl);
                        continue;
                    }
                    if (i == pCsMh.getClns().size() - 1) {
                        writer.write(pCsMh.getClSp() + clVl + "\r\n");
                        continue;
                    }
                    writer.write(pCsMh.getClSp() + clVl);
                }
            }
        }
    }

    public final IReflect getReflect() {
        return this.reflect;
    }

    public final void setReflect(IReflect pReflect) {
        this.reflect = pReflect;
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }

    public final IHlMaFrn getHlMaFrn() {
        return this.hlMaFrn;
    }

    public final void setHlMaFrn(IHlMaFrn pHlMaFrn) {
        this.hlMaFrn = pHlMaFrn;
    }
}

