/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.srv;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.dlg.IEvalFr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.fct.IFctCnToSt;
import org.beigesoft.hld.HldUvd;
import org.beigesoft.hld.IHlNmClCl;
import org.beigesoft.hld.IHlNmClSt;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IIdStr;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdl.Page;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rdb.ISqlQu;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.ISrvDt;
import org.beigesoft.srv.ISrvPg;

public class HlpEntPg<RS> {
    private ILog log;
    private II18n i18n;
    private IOrm orm;
    private IRdb<RS> rdb;
    private ISrvPg srvPg;
    private ISqlQu sqlQu;
    private ISrvDt srvDt;
    private HldUvd hldUvd;
    private IFctCnToSt fctCnvFd;
    private IHlNmClSt hldNmCnFd;
    private IHlNmClCl hldFdCls;

    public final void retPg(Map<String, Object> pRvs, IReqDt pRqd, Map<String, Class<? extends IHasId<?>>> pEntMp, boolean pDbgSh, IEvalFr<IReqDt, String> pMkFlt) throws Exception {
        Map<String, Integer> pgDpl;
        Integer roCnt;
        String ent;
        HashMap<String, Object> vs = new HashMap<String, Object>();
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        if (uvs.getOwnr() != null) {
            ent = uvs.getOwnr().getClass().getSimpleName();
            if (pDbgSh) {
                this.log.debug(pRvs, this.getClass(), "It's used entOw: " + ent);
            }
        } else {
            ent = pRqd.getParam("ent");
            if (pDbgSh) {
                this.log.debug(pRvs, this.getClass(), "It's used ent: " + ent);
            }
        }
        Class<IHasId<?>> cls = pEntMp.get(ent);
        HashSet<String> fltAp = null;
        if (pRqd.getParam("flyNdFltAp") != null) {
            fltAp = new HashSet<String>();
            uvs.setFltAp(fltAp);
            if (pDbgSh) {
                this.log.debug(pRvs, this.getClass(), "It's used fltAp: " + fltAp);
            }
        }
        StringBuffer sbWhe = this.revPgFltDt(pRvs, pRqd, cls, pDbgSh);
        HashMap<String, String> ordMp = new HashMap<String, String>();
        uvs.setOrdMp(ordMp);
        String quOrdBy = "";
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        if (pDbgSh) {
            this.log.debug(pRvs, this.getClass(), "It's used foprf: " + foprf);
        }
        String ordBy = pRqd.getParam(foprf + "ordBy");
        if (pDbgSh) {
            this.log.debug(pRvs, this.getClass(), "It's used ordBy: " + ordBy);
        }
        if (ordBy != null && !ordBy.equals("disabled")) {
            ordMp.put(foprf + "ordBy", ordBy);
            String desc = "";
            String orbyde = pRqd.getParam(foprf + "ordByDe");
            if (orbyde != null) {
                ordMp.put(foprf + "ordByDe", orbyde);
                if (!"off".equals(orbyde)) {
                    desc = " desc";
                }
            }
            quOrdBy = " order by " + ent.toUpperCase() + "." + ordBy.toUpperCase() + desc;
        } else {
            String obs;
            ordMp.put(foprf + "ordBy", this.hldUvd.stg(cls, "ordDf"));
            String orderByDesc = this.hldUvd.stg(cls, "orDeDf");
            ordMp.put(foprf + "ordByDe", orderByDesc);
            String ordDescSt = "";
            if (orderByDesc.equals("on")) {
                ordDescSt = " desc";
            }
            if ((obs = (String)ordMp.get(foprf + "ordBy")).indexOf(".") == -1) {
                obs = cls.getSimpleName() + "." + obs;
            }
            quOrdBy = " order by " + obs.toUpperCase() + ordDescSt;
        }
        if (pDbgSh) {
            this.log.debug(pRvs, this.getClass(), "It's used quOrdBy: " + quOrdBy);
        }
        String strWhe = null;
        String strFiWhe = null;
        if (pMkFlt != null) {
            strFiWhe = pMkFlt.eval(pRvs, pRqd);
            if (pDbgSh) {
                this.log.debug(pRvs, this.getClass(), "It's used pMkFlt/where: " + pMkFlt.getClass().getSimpleName() + "/" + strFiWhe);
            }
        }
        if (strFiWhe != null) {
            strWhe = sbWhe.length() > 0 ? strFiWhe + " and " + sbWhe.toString() : strFiWhe;
        } else if (sbWhe.length() > 1) {
            strWhe = sbWhe.toString();
        }
        if (strWhe != null) {
            if (strFiWhe != null) {
                String qu = this.sqlQu.evSel(pRvs, vs, cls).toString();
                qu = qu.substring(qu.indexOf("from"));
                qu = "select count(*) as TOROWS " + qu + " where " + strWhe;
                roCnt = this.rdb.evInt(qu, "TOROWS");
            } else {
                roCnt = this.orm.evRowCntWhe(pRvs, vs, cls, strWhe);
            }
        } else {
            roCnt = this.orm.evRowCnt(pRvs, vs, cls);
        }
        Integer pg = Integer.valueOf(pRqd.getParam("pg"));
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        Integer pgSz = cpf.getPgSz();
        int pgCnt = this.srvPg.evPgCnt(roCnt, pgSz);
        if (pg > pgCnt) {
            pg = pgCnt;
        }
        int fstRz = (pg - 1) * pgSz;
        String[] lstFds = this.hldUvd.lazLstFds(cls);
        Object[] ndFds = Arrays.copyOf(lstFds, lstFds.length);
        Arrays.sort(ndFds);
        vs.put(cls.getSimpleName() + "ndFds", ndFds);
        Map<String, String[]> pgFds = this.hldUvd.lazPgFds(cls);
        if (pgFds != null) {
            for (Map.Entry<String, String[]> entry : pgFds.entrySet()) {
                vs.put(entry.getKey() + "ndFds", entry.getValue());
            }
        }
        if ((pgDpl = this.hldUvd.lazPgDpl(cls)) != null) {
            for (Map.Entry<String, Integer> entry : pgDpl.entrySet()) {
                vs.put(entry.getKey() + "dpLv", entry.getValue());
            }
        }
        List<IHasId<?>> ents = strWhe != null || quOrdBy.length() > 0 ? (strWhe != null ? this.orm.retPgCnd(pRvs, vs, cls, "where " + strWhe + quOrdBy, fstRz, pgSz) : this.orm.retPgCnd(pRvs, vs, cls, quOrdBy, fstRz, pgSz)) : this.orm.retPg(pRvs, vs, cls, fstRz, pgSz);
        vs.remove(cls.getSimpleName() + "ndFds");
        Integer n = cpf.getPgTl();
        List<Page> list = this.srvPg.evPgs(pg, pgCnt, n);
        uvs.setPgs(list);
        uvs.setEnts(ents);
        uvs.setCls(cls);
    }

    public final <T extends IHasId<?>> StringBuffer revPgFltDt(Map<String, Object> pRvs, IReqDt pRqd, Class<T> pCls, boolean pDbgSh) throws Exception {
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        StringBuffer sbWhe = new StringBuffer("");
        HashMap<String, Object> fltMp = new HashMap<String, Object>();
        uvs.setFltMp(fltMp);
        for (String fdNm : this.hldUvd.lazLstFds(pCls)) {
            String flt = this.hldUvd.stg(pCls, fdNm, "flt");
            if (flt == null) {
                flt = this.hldUvd.stg(pCls, fdNm, "flth");
            }
            if (pDbgSh) {
                this.log.debug(pRvs, this.getClass(), "It's used flt/field: " + flt + "/" + fdNm);
            }
            if (flt == null) continue;
            if ("ent".equals(flt)) {
                this.mkWheEnt(sbWhe, pRqd, pCls, fdNm, uvs);
                continue;
            }
            if ("str".equals(flt)) {
                this.mkWheStr(sbWhe, pRqd, pCls, fdNm, uvs);
                continue;
            }
            if (flt.startsWith("dt")) {
                this.mkWheDtTm(sbWhe, pRqd, pCls, fdNm, "1", uvs);
                this.mkWheDtTm(sbWhe, pRqd, pCls, fdNm, "2", uvs);
                continue;
            }
            if ("enm".equals(flt)) {
                this.mkWheEnm(sbWhe, pRqd, pCls, fdNm, uvs);
                continue;
            }
            if ("bln".equals(flt)) {
                this.mkWheBln(sbWhe, pRqd, pCls, fdNm, uvs);
                continue;
            }
            if (flt.startsWith("expl")) {
                this.mkWheExcpl(sbWhe, pRqd, pCls, fdNm, uvs);
                continue;
            }
            this.mkWheStd(sbWhe, pRqd, pCls, fdNm, "1", uvs);
            this.mkWheStd(sbWhe, pRqd, pCls, fdNm, "2", uvs);
        }
        return sbWhe;
    }

    public final <T extends IHasId<?>> void mkWheStr(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, UvdVar pUvs) throws Exception {
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        String nmFldVal = foprf + pFdNm + "Vl";
        String fltVal = pRqd.getParam(nmFldVal);
        String nmFldOpr = foprf + pFdNm + "Opr";
        String fltOp = pRqd.getParam(nmFldOpr);
        String cond = null;
        String tbNm = pCls.getSimpleName().toUpperCase();
        if ("isnotnull".equals(fltOp) || "isnull".equals(fltOp)) {
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp);
        } else if (fltVal != null && fltOp != null && !fltOp.equals("disabled") && !fltOp.equals("")) {
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp) + " '" + fltVal + "'";
        }
        if (cond != null) {
            pUvs.getFltMp().put(nmFldVal, fltVal);
            pUvs.getFltMp().put(nmFldOpr, fltOp);
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp) + " " + fltVal);
            }
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
        }
    }

    public final <T extends IHasId<?>> void mkWheStd(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, String pParSuffix, UvdVar pUvs) throws Exception {
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        String nmFldVal = foprf + pFdNm + "Vl" + pParSuffix;
        String fltVal = pRqd.getParam(nmFldVal);
        String nmFldOpr = foprf + pFdNm + "Opr" + pParSuffix;
        String fltOp = pRqd.getParam(nmFldOpr);
        String cond = null;
        String tbNm = pCls.getSimpleName().toUpperCase();
        if ("isnotnull".equals(fltOp) || "isnull".equals(fltOp)) {
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp);
        } else if (fltVal != null && fltOp != null && !fltOp.equals("disabled") && !fltOp.equals("")) {
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp) + " " + fltVal;
        }
        if (cond != null) {
            pUvs.getFltMp().put(nmFldVal, fltVal);
            pUvs.getFltMp().put(nmFldOpr, fltOp);
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp) + " " + fltVal);
            }
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
        }
    }

    public final <T extends IHasId<?>> void mkWheDtTm(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, String pParSuffix, UvdVar pUvs) throws Exception {
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        String nmFldVal = foprf + pFdNm + "Vl" + pParSuffix;
        String fltVal = pRqd.getParam(nmFldVal);
        String nmFldOpr = foprf + pFdNm + "Opr" + pParSuffix;
        String fltOp = pRqd.getParam(nmFldOpr);
        String cond = null;
        String tbNm = pCls.getSimpleName().toUpperCase();
        if ("isnotnull".equals(fltOp) || "isnull".equals(fltOp)) {
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp);
        } else if (fltVal != null && fltOp != null && !fltOp.equals("disabled") && !fltOp.equals("")) {
            Date valDt = fltVal.contains(".") ? this.srvDt.from8601Full(fltVal) : (fltVal.contains(":") ? (fltVal.length() == 19 ? this.srvDt.from8601DateTimeSec(fltVal) : this.srvDt.from8601DateTime(fltVal)) : this.srvDt.from8601Date(fltVal));
            cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp) + " " + valDt.getTime();
        }
        if (cond != null) {
            pUvs.getFltMp().put(nmFldVal, fltVal);
            pUvs.getFltMp().put(nmFldOpr, fltOp);
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp) + " " + fltVal);
            }
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
        }
    }

    public final String toSqlOp(String pOper) throws ExcCode {
        if ("eq".equals(pOper)) {
            return "=";
        }
        if ("ne".equals(pOper)) {
            return "!=";
        }
        if ("gt".equals(pOper)) {
            return ">";
        }
        if ("gte".equals(pOper)) {
            return ">=";
        }
        if ("in".equals(pOper)) {
            return "in";
        }
        if ("lt".equals(pOper)) {
            return "<";
        }
        if ("lte".equals(pOper)) {
            return "<=";
        }
        if ("isnull".equals(pOper)) {
            return "is null";
        }
        if ("isnotnull".equals(pOper)) {
            return "is not null";
        }
        if ("like".equals(pOper)) {
            return "like";
        }
        throw new ExcCode(100, "Can't match SQL operator: " + pOper);
    }

    public final <T extends IHasId<?>> void mkWheEnt(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, UvdVar pUvs) throws Exception {
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String nmFldVlId = foprf + pFdNm + "VlId";
        String fltVlId = pRqd.getParam(nmFldVlId);
        String nmFldOpr = foprf + pFdNm + "Opr";
        String fltOp = pRqd.getParam(nmFldOpr);
        if (fltOp != null && !fltOp.equals("disabled")) {
            Class<?> fdCls = this.hldUvd.fldCls(pCls, pFdNm);
            boolean isStrId = IIdStr.class.isAssignableFrom(fdCls);
            if (fltVlId == null || fltVlId.length() == 0) {
                fltOp = fltOp.equals("eq") ? "isnull" : "isnotnull";
            }
            pUvs.getFltMp().put(nmFldOpr, fltOp);
            String flFrcdNm = foprf + "frcd";
            String flFrcdVl = pRqd.getParam(flFrcdNm);
            if (flFrcdVl != null) {
                pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
            }
            String tbNm = pCls.getSimpleName().toUpperCase();
            if (fltOp.equals("isnull") || fltOp.equals("isnotnull")) {
                String cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp);
                if (pSbw.toString().length() == 0) {
                    pSbw.append(cond);
                } else {
                    pSbw.append(" and " + cond);
                }
                if (pUvs.getFltAp() != null) {
                    pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp));
                }
            } else {
                pUvs.getFltMp().put(nmFldVlId, fltVlId);
                String nmFldVlAp = foprf + pFdNm + "VlAp";
                String fltVlAp = pRqd.getParam(nmFldVlAp);
                pUvs.getFltMp().put(nmFldVlAp, fltVlAp);
                String valId = fltOp.equals("in") ? "(" + fltVlId + ")" : (isStrId ? "'" + fltVlId + "'" : fltVlId);
                String cond = tbNm + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp) + " " + valId;
                if (pSbw.toString().length() == 0) {
                    pSbw.append(cond);
                } else {
                    pSbw.append(" and " + cond);
                }
                if (pUvs.getFltAp() != null) {
                    pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp) + " " + fltVlAp);
                }
            }
        }
    }

    public final <T extends IHasId<?>> void mkWheEnm(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, UvdVar pUvs) throws Exception {
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        String nmFldVal = foprf + pFdNm + "Vl";
        String fltVal = pRqd.getParam(nmFldVal);
        String nmFldOpr = foprf + pFdNm + "Opr";
        String fltOp = pRqd.getParam(nmFldOpr);
        if (fltVal != null && fltVal.length() > 0 && fltOp != null && !fltOp.equals("disabled") && !fltOp.equals("")) {
            String valAppear;
            String val;
            Class<?> classEnum = this.hldFdCls.get(pCls, pFdNm);
            if (fltOp.equals("in")) {
                StringBuffer sbVal = new StringBuffer("(");
                StringBuffer sbValAppear = new StringBuffer("(");
                boolean isFirst = true;
                for (String vl : fltVal.split(",")) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sbVal.append(", ");
                        sbValAppear.append(", ");
                    }
                    Enum enVal = ((Enum[])classEnum.getEnumConstants())[Integer.parseInt(vl)];
                    sbVal.append(vl);
                    sbValAppear.append(this.getI18n().getMsg(enVal.name()));
                }
                val = sbVal.toString() + ")";
                valAppear = sbValAppear.toString() + ")";
                pUvs.getFltMp().put(nmFldVal, fltVal);
            } else {
                Integer valInt = Integer.valueOf(fltVal);
                Enum enVal = ((Enum[])classEnum.getEnumConstants())[valInt];
                val = fltVal;
                valAppear = this.getI18n().getMsg(enVal.name());
                pUvs.getFltMp().put(nmFldVal, valInt);
            }
            pUvs.getFltMp().put(foprf + pFdNm + "VlAp", valAppear);
            pUvs.getFltMp().put(nmFldOpr, fltOp);
            String cond = pCls.getSimpleName().toUpperCase() + "." + pFdNm.toUpperCase() + " " + this.toSqlOp(fltOp) + " " + val;
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " " + this.getI18n().getMsg(fltOp) + " " + valAppear);
            }
        }
    }

    public final <T extends IHasId<?>> void mkWheExcpl(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, UvdVar pUvs) throws Exception {
        String nmFldVal;
        String fltVal;
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        if ((fltVal = pRqd.getParam(nmFldVal = foprf + pFdNm + "Vl")) != null && fltVal.length() > 0 && !fltVal.equals("disabled")) {
            pUvs.getFltMp().put(nmFldVal, fltVal);
            String cond = fltVal.replace(" gte ", ">=");
            cond = cond.replace(" lte ", "<=");
            cond = cond.replace(" lt ", "<");
            cond = cond.replace(" gt ", ">");
            cond = cond.replace(" ne ", "!=");
            cond = cond.replace(" eq ", "=");
            cond = cond.replace(" apst ", "'");
            cond = cond.replace(" prcnt ", "%");
            cond = cond.replace(" undln ", "_");
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(cond);
            }
        }
    }

    public final <T extends IHasId<?>> void mkWheBln(StringBuffer pSbw, IReqDt pRqd, Class<T> pCls, String pFdNm, UvdVar pUvs) throws Exception {
        String nmFldVal;
        String fltVal;
        String rnd = pRqd.getParam("rnd");
        String foprf = rnd != null && rnd.startsWith("pd") ? "fopd" : (rnd != null && rnd.startsWith("p") ? "fop" : "fom");
        String flFrcdNm = foprf + "frcd";
        String flFrcdVl = pRqd.getParam(flFrcdNm);
        if (flFrcdVl != null) {
            pUvs.getFltMp().put(flFrcdNm, flFrcdVl);
        }
        if ((fltVal = pRqd.getParam(nmFldVal = foprf + pFdNm + "Vl")) != null && (fltVal.length() == 0 || "null".equals(fltVal))) {
            fltVal = null;
        }
        pUvs.getFltMp().put(nmFldVal, fltVal);
        if (fltVal != null) {
            int intVal = 0;
            if (fltVal.equals("true")) {
                intVal = 1;
            }
            String cond = pCls.getSimpleName().toUpperCase() + "." + pFdNm.toUpperCase() + " = " + intVal;
            if (pSbw.toString().length() == 0) {
                pSbw.append(cond);
            } else {
                pSbw.append(" and " + cond);
            }
            if (pUvs.getFltAp() != null) {
                pUvs.getFltAp().add(this.getI18n().getMsg(pFdNm) + " = " + fltVal);
            }
        }
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrvPg getSrvPg() {
        return this.srvPg;
    }

    public final void setSrvPg(ISrvPg pSrvPg) {
        this.srvPg = pSrvPg;
    }

    public final ISrvDt getSrvDt() {
        return this.srvDt;
    }

    public final void setSrvDt(ISrvDt pSrvDt) {
        this.srvDt = pSrvDt;
    }

    public final IFctCnToSt getFctCnvFd() {
        return this.fctCnvFd;
    }

    public final void setFctCnvFd(IFctCnToSt pFctCnvFd) {
        this.fctCnvFd = pFctCnvFd;
    }

    public final IHlNmClSt getHldNmCnFd() {
        return this.hldNmCnFd;
    }

    public final void setHldNmCnFd(IHlNmClSt pHldNmCnFd) {
        this.hldNmCnFd = pHldNmCnFd;
    }

    public final IHlNmClCl getHldFdCls() {
        return this.hldFdCls;
    }

    public final void setHldFdCls(IHlNmClCl pHldFdCls) {
        this.hldFdCls = pHldFdCls;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final ISqlQu getSqlQu() {
        return this.sqlQu;
    }

    public final void setSqlQu(ISqlQu pSqlQu) {
        this.sqlQu = pSqlQu;
    }

    public final HldUvd getHldUvd() {
        return this.hldUvd;
    }

    public final void setHldUvd(HldUvd pHldUvd) {
        this.hldUvd = pHldUvd;
    }
}

