/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.srv;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.beigesoft.log.ILog;
import org.beigesoft.srv.II18n;

public class I18n
implements II18n {
    private ILog log;
    private ResourceBundle messages;
    private final Map<String, ResourceBundle> messagesMap = new HashMap<String, ResourceBundle>();

    public final void initDefault() {
        try {
            this.messages = null;
            this.messages = ResourceBundle.getBundle("Msgs");
        }
        catch (Exception e) {
            this.log.error(null, I18n.class, " when loading msgs for default locale ", (Throwable)e);
        }
        if (this.messages != null) {
            this.messagesMap.put(Locale.getDefault().getLanguage(), this.messages);
            this.log.info(null, I18n.class, "Added messages for default locale: " + Locale.getDefault());
        } else {
            this.log.error(null, I18n.class, "There is no messages for current locale: " + Locale.getDefault());
        }
    }

    public final void add(String[] pLangCountries) {
        if (pLangCountries != null && pLangCountries.length % 2 == 0) {
            ResourceBundle firstMsg = null;
            for (int i = 0; i < pLangCountries.length / 2; ++i) {
                Locale locale = new Locale(pLangCountries[i * 2], pLangCountries[i * 2 + 1]);
                if (this.messages == null || !locale.equals(Locale.getDefault())) {
                    ResourceBundle msgs = null;
                    try {
                        msgs = ResourceBundle.getBundle("Msgs", locale);
                    }
                    catch (Exception e) {
                        this.log.error(null, I18n.class, " when loading msg for locale " + locale, (Throwable)e);
                    }
                    if (msgs != null) {
                        if (firstMsg == null) {
                            firstMsg = msgs;
                        }
                        this.messagesMap.put(pLangCountries[i * 2], msgs);
                        this.log.info(null, I18n.class, "Added messages for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
                        continue;
                    }
                    this.log.error(null, I18n.class, "There is no messages for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
                    continue;
                }
                this.log.info(null, I18n.class, "Messages already added as default for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
            }
            if (this.messages == null) {
                this.messages = firstMsg;
            }
        } else {
            String msg = null;
            if (pLangCountries == null) {
                msg = "is null!";
            } else {
                for (String str : pLangCountries) {
                    msg = msg == null ? str : msg + "/" + str;
                }
            }
            this.log.error(null, I18n.class, "Parameters language error, pLangCountries: " + msg);
        }
    }

    @Override
    public final String getMsg(String key) {
        try {
            return this.messages.getString(key);
        }
        catch (Exception e) {
            return "[" + key + "]";
        }
    }

    @Override
    public final String getMsg(String pKey, String pLang) {
        try {
            ResourceBundle mb = this.messagesMap.get(pLang);
            if (mb != null) {
                return mb.getString(pKey);
            }
            return this.getMsg(pKey);
        }
        catch (Exception e) {
            return "[" + pKey + "]-" + pLang;
        }
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final ResourceBundle getMessages() {
        return this.messages;
    }

    public final void setMessages(ResourceBundle pMessages) {
        this.messages = pMessages;
    }

    public final Map<String, ResourceBundle> getMessagesMap() {
        return this.messagesMap;
    }
}

