/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.cache;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.beyene.sius.cache.Cache;
import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.unit.Unit;

final class SimpleCache<D extends Dimension<D>, B extends Unit<D, B, B>, U extends Unit<D, B, U>>
implements Cache<D, B, U> {
    private final int capacity;
    private final Map<Double, U> map;

    SimpleCache(int capacity) {
        this.capacity = capacity;
        this.map = Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    public U lookUp(double d) {
        return (U)((Unit)this.map.get(d));
    }

    @Override
    public boolean put(U unit) {
        if (this.map.size() >= this.capacity && !this.map.containsKey(unit.getValue())) {
            return false;
        }
        this.map.put(unit.getValue(), unit);
        return true;
    }
}

