/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.operation.functor;

import java.util.LinkedList;
import java.util.List;
import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.operation.functor.Functor;
import org.beyene.sius.unit.Unit;
import org.beyene.sius.unit.UnitId;

abstract class AbstractFunctor<D extends Dimension<D>, B extends Unit<D, B, B>, TARGET_UNIT extends Unit<D, B, TARGET_UNIT>, F extends Functor<D, B, TARGET_UNIT, F>>
implements Functor<D, B, TARGET_UNIT, F> {
    private final String functionName;
    protected final UnitId<D, B, TARGET_UNIT> targetId;
    protected final List<Unit<D, B, ?>> operands = new LinkedList();
    protected TARGET_UNIT cachedResult;

    public AbstractFunctor(UnitId<D, B, TARGET_UNIT> targetId, String functionName) {
        this.targetId = targetId;
        this.functionName = functionName;
    }

    @Override
    public F op(Unit<D, B, ?> op) {
        this.resetCache();
        this.operands.add(op);
        return this._this();
    }

    @Override
    public abstract TARGET_UNIT apply();

    protected abstract F _this();

    private void resetCache() {
        this.cachedResult = null;
    }

    @Override
    public String toString() {
        return String.format("%s [targetId=%s, operands=%s]", this.functionName, this.targetId, this.operands);
    }
}

