/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.operation.functor;

import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.operation.Operation;
import org.beyene.sius.operation.functor.AbstractFunctor;
import org.beyene.sius.operation.functor.ArithmeticMean;
import org.beyene.sius.unit.Unit;
import org.beyene.sius.unit.UnitFactory;
import org.beyene.sius.unit.UnitId;

final class ArithmeticMeanImpl<D extends Dimension<D>, B extends Unit<D, B, B>, TARGET_UNIT extends Unit<D, B, TARGET_UNIT>>
extends AbstractFunctor<D, B, TARGET_UNIT, ArithmeticMean<D, B, TARGET_UNIT>>
implements ArithmeticMean<D, B, TARGET_UNIT> {
    private TARGET_UNIT cachedResult;

    public ArithmeticMeanImpl(UnitId<D, B, TARGET_UNIT> targetId) {
        super(targetId, ArithmeticMean.class.getSimpleName());
    }

    @Override
    public TARGET_UNIT apply() {
        if (this.operands.isEmpty()) {
            return (TARGET_UNIT)UnitFactory.valueOf(0.0, this.targetId);
        }
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        double res = 0.0;
        for (Unit op : this.operands) {
            res += Operation.convert(op, this.targetId).getValue();
        }
        double mean = res / (double)this.operands.size();
        this.cachedResult = UnitFactory.valueOf(mean, this.targetId);
        return this.cachedResult;
    }

    @Override
    protected ArithmeticMean<D, B, TARGET_UNIT> _this() {
        return this;
    }
}

