/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.unit.Unit;
import org.beyene.sius.unit.UnitId;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.FactoryLength;
import org.beyene.sius.unit.impl.FactoryMass;
import org.beyene.sius.unit.impl.FactorySpeed;
import org.beyene.sius.unit.impl.FactoryTemperature;
import org.beyene.sius.unit.impl.FactoryTime;

public final class UnitFactory {
    private static final Map<UnitId<?, ?, ?>, Unit<?, ?, ?>> instanceMapMutable = new HashMap();
    private static final Map<UnitId<?, ?, ?>, Unit<?, ?, ?>> instanceMap;

    private UnitFactory() {
    }

    public static <D extends Dimension<D>, B extends Unit<D, B, B>, U extends Unit<D, B, U>, UID extends UnitId<D, B, U>> U valueOf(double d, UID id) {
        Unit<?, ?, ?> unit = instanceMap.get(id);
        if (unit == null) {
            throw new UnsupportedUnitException(id);
        }
        return (U)unit.valueOf(d);
    }

    static {
        instanceMapMutable.put(UnitIdentifier.KILOGRAM, FactoryMass.kg(0.0));
        instanceMapMutable.put(UnitIdentifier.POUND, FactoryMass.lb(0.0));
        instanceMapMutable.put(UnitIdentifier.METER, FactoryLength.meter(0.0));
        instanceMapMutable.put(UnitIdentifier.MILE, FactoryLength.mile(0.0));
        instanceMapMutable.put(UnitIdentifier.YARD, FactoryLength.yard(0.0));
        instanceMapMutable.put(UnitIdentifier.FOOT, FactoryLength.foot(0.0));
        instanceMapMutable.put(UnitIdentifier.INCH, FactoryLength.inch(0.0));
        instanceMapMutable.put(UnitIdentifier.SECOND, FactoryTime.second(0.0));
        instanceMapMutable.put(UnitIdentifier.MINUTE, FactoryTime.minute(0.0));
        instanceMapMutable.put(UnitIdentifier.HOUR, FactoryTime.hour(0.0));
        instanceMapMutable.put(UnitIdentifier.KELVIN, FactoryTemperature.kelvin(0.0));
        instanceMapMutable.put(UnitIdentifier.CELSIUS, FactoryTemperature.celsius(0.0));
        instanceMapMutable.put(UnitIdentifier.FAHRENHEIT, FactoryTemperature.fahrenheit(0.0));
        instanceMapMutable.put(UnitIdentifier.METER_PER_SECOND, FactorySpeed.mps(0.0));
        instanceMapMutable.put(UnitIdentifier.MILES_PER_HOUR, FactorySpeed.mph(0.0));
        instanceMap = Collections.unmodifiableMap(instanceMapMutable);
    }

    public static class UnsupportedUnitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedUnitException(UnitId<?, ?, ?> uid) {
            super(String.format("Unit identified by %s is not supported!", uid.getClass().getSimpleName()));
        }
    }
}

