/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit;

import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.dimension.Mass;
import org.beyene.sius.dimension.Temperature;
import org.beyene.sius.dimension.Time;
import org.beyene.sius.dimension.composition.Speed;
import org.beyene.sius.unit.Unit;
import org.beyene.sius.unit.UnitId;
import org.beyene.sius.unit.composition.CompositeUnitId;
import org.beyene.sius.unit.composition.speed.MeterPerSecond;
import org.beyene.sius.unit.composition.speed.MilesPerHour;
import org.beyene.sius.unit.length.Foot;
import org.beyene.sius.unit.length.Inch;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.unit.length.Mile;
import org.beyene.sius.unit.length.Yard;
import org.beyene.sius.unit.mass.KiloGram;
import org.beyene.sius.unit.mass.Pound;
import org.beyene.sius.unit.temperature.Celsius;
import org.beyene.sius.unit.temperature.Fahrenheit;
import org.beyene.sius.unit.temperature.Kelvin;
import org.beyene.sius.unit.time.Hour;
import org.beyene.sius.unit.time.Minute;
import org.beyene.sius.unit.time.Second;

public final class UnitIdentifier {
    public static final MeterId METER = new MeterId();
    public static final MileId MILE = new MileId();
    public static final YardId YARD = new YardId();
    public static final FootId FOOT = new FootId();
    public static final InchId INCH = new InchId();
    public static final KiloGramId KILOGRAM = new KiloGramId();
    public static final PoundId POUND = new PoundId();
    public static final SecondId SECOND = new SecondId();
    public static final MinuteId MINUTE = new MinuteId();
    public static final HourId HOUR = new HourId();
    public static final KelvinId KELVIN = new KelvinId();
    public static final CelsiusId CELSIUS = new CelsiusId();
    public static final FahrenheitId FAHRENHEIT = new FahrenheitId();
    public static final MeterPerSecondId METER_PER_SECOND = new MeterPerSecondId();
    public static final MilesPerHourId MILES_PER_HOUR = new MilesPerHourId();

    private UnitIdentifier() {
    }

    private static abstract class AbstractUnitId<D extends Dimension<D>, BASE extends Unit<D, BASE, BASE>, U extends Unit<D, BASE, U>>
    implements UnitId<D, BASE, U> {
        private final String id = this.getClass().getName();

        private AbstractUnitId() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractUnitId)) {
                return false;
            }
            AbstractUnitId other = (AbstractUnitId)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return "UnitId [id=" + this.getClass().getSimpleName() + "]";
        }
    }

    private static class MilesPerHourId
    extends AbstractUnitId<Speed, MeterPerSecond, MilesPerHour> {
        private MilesPerHourId() {
        }
    }

    private static class MeterPerSecondId
    extends AbstractUnitId<Speed, MeterPerSecond, MeterPerSecond>
    implements CompositeUnitId<Length, Meter, Meter, Time, Second, Second, Speed, MeterPerSecond, MeterPerSecond> {
        private MeterPerSecondId() {
        }

        @Override
        public UnitId<Length, Meter, Meter> getComponentUnit1Id() {
            return METER;
        }

        @Override
        public UnitId<Time, Second, Second> getComponentUnit2Id() {
            return SECOND;
        }
    }

    private static class FahrenheitId
    extends AbstractUnitId<Temperature, Kelvin, Fahrenheit> {
        private FahrenheitId() {
        }
    }

    private static class CelsiusId
    extends AbstractUnitId<Temperature, Kelvin, Celsius> {
        private CelsiusId() {
        }
    }

    private static class KelvinId
    extends AbstractUnitId<Temperature, Kelvin, Kelvin> {
        private KelvinId() {
        }
    }

    private static class HourId
    extends AbstractUnitId<Time, Second, Hour> {
        private HourId() {
        }
    }

    private static class MinuteId
    extends AbstractUnitId<Time, Second, Minute> {
        private MinuteId() {
        }
    }

    private static class SecondId
    extends AbstractUnitId<Time, Second, Second> {
        private SecondId() {
        }
    }

    private static class PoundId
    extends AbstractUnitId<Mass, KiloGram, Pound> {
        private PoundId() {
        }
    }

    private static class KiloGramId
    extends AbstractUnitId<Mass, KiloGram, KiloGram> {
        private KiloGramId() {
        }
    }

    private static class InchId
    extends AbstractUnitId<Length, Meter, Inch> {
        private InchId() {
        }
    }

    private static class FootId
    extends AbstractUnitId<Length, Meter, Foot> {
        private FootId() {
        }
    }

    private static class YardId
    extends AbstractUnitId<Length, Meter, Yard> {
        private YardId() {
        }
    }

    private static class MileId
    extends AbstractUnitId<Length, Meter, Mile> {
        private MileId() {
        }
    }

    private static class MeterId
    extends AbstractUnitId<Length, Meter, Meter> {
        private MeterId() {
        }
    }
}

