/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.dimension.Dimension;
import org.beyene.sius.unit.Unit;
import org.beyene.sius.unit.UnitId;
import org.beyene.sius.unit.impl.StaticCache;

public abstract class AbstractUnit<D extends Dimension<D>, BASE extends Unit<D, BASE, BASE>, SELF extends Unit<D, BASE, SELF>>
implements Unit<D, BASE, SELF> {
    protected final double value;
    private final D dimension;
    private final UnitId<D, BASE, SELF> unitId;
    private final Class<? extends SELF> interfaceClass;
    private final transient Cache<D, BASE, SELF> dynamicCache;
    private final transient StaticCache<D, BASE, SELF> staticCache;

    public AbstractUnit(double value, D dimension, UnitId<D, BASE, SELF> unitId, Class<? extends SELF> interfaceClass, Cache<D, BASE, SELF> dynamicCache, StaticCache<D, BASE, SELF> staticCache) {
        this.value = value;
        this.dimension = dimension;
        this.unitId = unitId;
        this.interfaceClass = interfaceClass;
        this.dynamicCache = dynamicCache;
        this.staticCache = staticCache;
    }

    @Override
    public D getDimension() {
        return this.dimension;
    }

    @Override
    public UnitId<D, BASE, SELF> getIdentifier() {
        return this.unitId;
    }

    @Override
    public abstract SELF fromBase(BASE var1);

    @Override
    public abstract BASE toBase();

    @Override
    public SELF valueOf(double d) {
        int i;
        if (this.value == d) {
            return this._this();
        }
        if (this._has_static_cache() && d == Math.floor(d) && !Double.isInfinite(d) && (i = (int)d) >= this.staticCache.low && i <= this.staticCache.high) {
            return this.staticCache.cache[i + -this.staticCache.low];
        }
        if (this._has_dynamic_cache()) {
            SELF cached = this.dynamicCache.lookUp(d);
            if (cached != null) {
                return cached;
            }
            cached = this._new_instance(d);
            this.dynamicCache.put(cached);
            return cached;
        }
        return this._new_instance(d);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interfaceClass == null ? 0 : this.interfaceClass.getName().hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.interfaceClass.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Unit other = (Unit)this.interfaceClass.cast(obj);
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.getValue());
    }

    @Override
    public String toString() {
        return this.interfaceClass.getSimpleName() + " [value=" + this.value + "]";
    }

    protected abstract SELF _this();

    protected abstract SELF _new_instance(double var1);

    private boolean _has_static_cache() {
        return this.staticCache != null;
    }

    private boolean _has_dynamic_cache() {
        return this.dynamicCache != null;
    }
}

