/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Temperature;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryTemperature;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.temperature.Celsius;
import org.beyene.sius.unit.temperature.Kelvin;
import org.beyene.sius.util.Preferences;

final class CelsiusImpl
extends AbstractUnit<Temperature, Kelvin, Celsius>
implements Celsius {
    private static final transient Cache<Temperature, Kelvin, Celsius> dynamicCache;
    private static final transient StaticCache<Temperature, Kelvin, Celsius> staticCache;

    public CelsiusImpl(double value) {
        super(value, Temperature.INSTANCE, UnitIdentifier.CELSIUS, Celsius.class, dynamicCache, staticCache);
    }

    @Override
    public Celsius fromBase(Kelvin base) {
        return (Celsius)this.valueOf(base.getValue() - 273.15);
    }

    @Override
    public Kelvin toBase() {
        return FactoryTemperature.kelvin(this.value + 273.15);
    }

    @Override
    protected Celsius _this() {
        return this;
    }

    @Override
    protected Celsius _new_instance(double value) {
        return new CelsiusImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("celsius.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.CELSIUS, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("celsius.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("celsius.cache.static.low", 0), sizeStatic, CelsiusImpl.class) : null;
    }
}

