/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Temperature;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryTemperature;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.temperature.Fahrenheit;
import org.beyene.sius.unit.temperature.Kelvin;
import org.beyene.sius.util.Preferences;

final class FahrenheitImpl
extends AbstractUnit<Temperature, Kelvin, Fahrenheit>
implements Fahrenheit {
    private static final transient Cache<Temperature, Kelvin, Fahrenheit> dynamicCache;
    private static final transient StaticCache<Temperature, Kelvin, Fahrenheit> staticCache;

    public FahrenheitImpl(double value) {
        super(value, Temperature.INSTANCE, UnitIdentifier.FAHRENHEIT, Fahrenheit.class, dynamicCache, staticCache);
    }

    @Override
    public Fahrenheit fromBase(Kelvin base) {
        return (Fahrenheit)this.valueOf(base.getValue() * 1.8 - 459.67);
    }

    @Override
    public Kelvin toBase() {
        return FactoryTemperature.kelvin((this.value + 459.67) * 0.5555555555555556);
    }

    @Override
    protected Fahrenheit _this() {
        return this;
    }

    @Override
    protected Fahrenheit _new_instance(double value) {
        return new FahrenheitImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("fahrenheit.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.FAHRENHEIT, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("fahrenheit.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("fahrenheit.cache.static.low", 0), sizeStatic, FahrenheitImpl.class) : null;
    }
}

