/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryLength;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.length.Foot;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.util.Preferences;

final class FootImpl
extends AbstractUnit<Length, Meter, Foot>
implements Foot {
    private static final transient Cache<Length, Meter, Foot> dynamicCache;
    private static final transient StaticCache<Length, Meter, Foot> staticCache;

    public FootImpl(double value) {
        super(value, Length.INSTANCE, UnitIdentifier.FOOT, Foot.class, dynamicCache, staticCache);
    }

    @Override
    public Foot fromBase(Meter base) {
        return (Foot)this.valueOf(base.getValue() / 0.3048);
    }

    @Override
    public Meter toBase() {
        return FactoryLength.meter(this.value * 0.3048);
    }

    @Override
    protected Foot _this() {
        return this;
    }

    @Override
    protected Foot _new_instance(double value) {
        return new FootImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("foot.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.FOOT, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("foot.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("foot.cache.static.low", 0), sizeStatic, FootImpl.class) : null;
    }
}

