/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Time;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryTime;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.time.Hour;
import org.beyene.sius.unit.time.Second;
import org.beyene.sius.util.Preferences;

final class HourImpl
extends AbstractUnit<Time, Second, Hour>
implements Hour {
    private static final transient Cache<Time, Second, Hour> dynamicCache;
    private static final transient StaticCache<Time, Second, Hour> staticCache;

    public HourImpl(double value) {
        super(value, Time.INSTANCE, UnitIdentifier.HOUR, HourImpl.class, dynamicCache, staticCache);
    }

    @Override
    public Hour fromBase(Second base) {
        return (Hour)this.valueOf(base.getValue() / 3600.0);
    }

    @Override
    public Second toBase() {
        return FactoryTime.second(this.value * 3600.0);
    }

    @Override
    protected Hour _this() {
        return this;
    }

    @Override
    protected Hour _new_instance(double value) {
        return new HourImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("hour.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.HOUR, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("hour.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("hour.cache.static.low", 0), sizeStatic, HourImpl.class) : null;
    }
}

