/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryLength;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.length.Inch;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.util.Preferences;

final class InchImpl
extends AbstractUnit<Length, Meter, Inch>
implements Inch {
    private static final transient Cache<Length, Meter, Inch> dynamicCache;
    private static final transient StaticCache<Length, Meter, Inch> staticCache;

    public InchImpl(double value) {
        super(value, Length.INSTANCE, UnitIdentifier.INCH, Inch.class, dynamicCache, staticCache);
    }

    @Override
    public Inch fromBase(Meter base) {
        return (Inch)this.valueOf(base.getValue() / 0.0254);
    }

    @Override
    public Meter toBase() {
        return FactoryLength.meter(this.value * 0.0254);
    }

    @Override
    protected Inch _this() {
        return this;
    }

    @Override
    protected Inch _new_instance(double value) {
        return new InchImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("inch.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.INCH, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("inch.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("inch.cache.static.low", 0), sizeStatic, InchImpl.class) : null;
    }
}

