/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Temperature;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.temperature.Kelvin;
import org.beyene.sius.util.Preferences;

final class KelvinImpl
extends AbstractUnit<Temperature, Kelvin, Kelvin>
implements Kelvin {
    private static final transient Cache<Temperature, Kelvin, Kelvin> dynamicCache;
    private static final transient StaticCache<Temperature, Kelvin, Kelvin> staticCache;

    public KelvinImpl(double value) {
        super(value, Temperature.INSTANCE, UnitIdentifier.KELVIN, Kelvin.class, dynamicCache, staticCache);
    }

    @Override
    public Kelvin fromBase(Kelvin base) {
        return (Kelvin)this.valueOf(base.getValue());
    }

    @Override
    public Kelvin toBase() {
        return this;
    }

    @Override
    protected Kelvin _this() {
        return this;
    }

    @Override
    protected Kelvin _new_instance(double value) {
        return new KelvinImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("kelvin.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.KELVIN, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("kelvin.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("kelvin.cache.static.low", 0), sizeStatic, KelvinImpl.class) : null;
    }
}

