/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Mass;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.mass.KiloGram;
import org.beyene.sius.util.Preferences;

final class KiloGramImpl
extends AbstractUnit<Mass, KiloGram, KiloGram>
implements KiloGram {
    private static final transient Cache<Mass, KiloGram, KiloGram> dynamicCache;
    private static final transient StaticCache<Mass, KiloGram, KiloGram> staticCache;

    public KiloGramImpl(double value) {
        super(value, Mass.INSTANCE, UnitIdentifier.KILOGRAM, KiloGram.class, dynamicCache, staticCache);
    }

    @Override
    public KiloGram fromBase(KiloGram base) {
        return (KiloGram)this.valueOf(base.getValue());
    }

    @Override
    public KiloGram toBase() {
        return this;
    }

    @Override
    protected KiloGram _this() {
        return this;
    }

    @Override
    protected KiloGram _new_instance(double value) {
        return new KiloGramImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("kg.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.KILOGRAM, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("kg.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("kg.cache.static.low", 0), sizeStatic, KiloGramImpl.class) : null;
    }
}

