/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryLength;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.unit.length.Mile;
import org.beyene.sius.util.Preferences;

final class MileImpl
extends AbstractUnit<Length, Meter, Mile>
implements Mile {
    private static final transient Cache<Length, Meter, Mile> dynamicCache;
    private static final transient StaticCache<Length, Meter, Mile> staticCache;

    public MileImpl(double value) {
        super(value, Length.INSTANCE, UnitIdentifier.MILE, Mile.class, dynamicCache, staticCache);
    }

    @Override
    public Mile fromBase(Meter base) {
        return (Mile)this.valueOf(base.getValue() / 1609.344);
    }

    @Override
    public Meter toBase() {
        return FactoryLength.meter(this.value * 1609.344);
    }

    @Override
    protected Mile _this() {
        return this;
    }

    @Override
    protected Mile _new_instance(double value) {
        return new MileImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("mile.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.MILE, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("mile.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("mile.cache.static.low", 0), sizeStatic, MileImpl.class) : null;
    }
}

