/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.dimension.Time;
import org.beyene.sius.dimension.composition.Speed;
import org.beyene.sius.unit.UnitId;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.composition.speed.MeterPerSecond;
import org.beyene.sius.unit.composition.speed.MilesPerHour;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactorySpeed;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.unit.length.Mile;
import org.beyene.sius.unit.time.Hour;
import org.beyene.sius.unit.time.Second;
import org.beyene.sius.util.Preferences;

final class MilesPerHourImpl
extends AbstractUnit<Speed, MeterPerSecond, MilesPerHour>
implements MilesPerHour {
    private static final transient Cache<Speed, MeterPerSecond, MilesPerHour> dynamicCache;
    private static final transient StaticCache<Speed, MeterPerSecond, MilesPerHour> staticCache;

    public MilesPerHourImpl(double value) {
        super(value, Speed.INSTANCE, UnitIdentifier.MILES_PER_HOUR, MilesPerHour.class, dynamicCache, staticCache);
    }

    @Override
    public UnitId<Length, Meter, Mile> getComponentUnit1Id() {
        return UnitIdentifier.MILE;
    }

    @Override
    public UnitId<Time, Second, Hour> getComponentUnit2Id() {
        return UnitIdentifier.HOUR;
    }

    @Override
    public MilesPerHour fromBase(MeterPerSecond base) {
        return (MilesPerHour)this.valueOf(base.getValue() / 0.44704);
    }

    @Override
    public MeterPerSecond toBase() {
        return FactorySpeed.mps(this.value * 0.44704);
    }

    @Override
    protected MilesPerHour _this() {
        return this;
    }

    @Override
    protected MilesPerHour _new_instance(double value) {
        return new MilesPerHourImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("mph.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.MILES_PER_HOUR, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("mph.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("mph.cache.static.low", 0), sizeStatic, MilesPerHourImpl.class) : null;
    }
}

