/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Time;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryTime;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.time.Minute;
import org.beyene.sius.unit.time.Second;
import org.beyene.sius.util.Preferences;

final class MinuteImpl
extends AbstractUnit<Time, Second, Minute>
implements Minute {
    private static final transient Cache<Time, Second, Minute> dynamicCache;
    private static final transient StaticCache<Time, Second, Minute> staticCache;

    public MinuteImpl(double value) {
        super(value, Time.INSTANCE, UnitIdentifier.MINUTE, Minute.class, dynamicCache, staticCache);
    }

    @Override
    public Minute fromBase(Second base) {
        return (Minute)this.valueOf(base.getValue() / 60.0);
    }

    @Override
    public Second toBase() {
        return FactoryTime.second(this.value * 60.0);
    }

    @Override
    protected Minute _this() {
        return this;
    }

    @Override
    protected Minute _new_instance(double value) {
        return new MinuteImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("minute.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.MINUTE, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("minute.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("minute.cache.static.low", 0), sizeStatic, MinuteImpl.class) : null;
    }
}

