/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Mass;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryMass;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.mass.KiloGram;
import org.beyene.sius.unit.mass.Pound;
import org.beyene.sius.util.Preferences;

final class PoundImpl
extends AbstractUnit<Mass, KiloGram, Pound>
implements Pound {
    private static final transient Cache<Mass, KiloGram, Pound> dynamicCache;
    private static final transient StaticCache<Mass, KiloGram, Pound> staticCache;

    public PoundImpl(double value) {
        super(value, Mass.INSTANCE, UnitIdentifier.POUND, Pound.class, dynamicCache, staticCache);
    }

    @Override
    public Pound fromBase(KiloGram base) {
        return (Pound)this.valueOf(base.getValue() / 0.45359237);
    }

    @Override
    public KiloGram toBase() {
        return FactoryMass.kg(this.value * 0.45359237);
    }

    @Override
    protected Pound _this() {
        return this;
    }

    @Override
    protected Pound _new_instance(double value) {
        return new PoundImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("pound.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.POUND, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("pound.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("pound.cache.static.low", 0), sizeStatic, PoundImpl.class) : null;
    }
}

