/*
 * Decompiled with CFR 0.152.
 */
package org.beyene.sius.unit.impl;

import org.beyene.sius.cache.Cache;
import org.beyene.sius.cache.Caches;
import org.beyene.sius.dimension.Length;
import org.beyene.sius.unit.UnitIdentifier;
import org.beyene.sius.unit.impl.AbstractUnit;
import org.beyene.sius.unit.impl.FactoryLength;
import org.beyene.sius.unit.impl.StaticCache;
import org.beyene.sius.unit.length.Meter;
import org.beyene.sius.unit.length.Yard;
import org.beyene.sius.util.Preferences;

final class YardImpl
extends AbstractUnit<Length, Meter, Yard>
implements Yard {
    private static final transient Cache<Length, Meter, Yard> dynamicCache;
    private static final transient StaticCache<Length, Meter, Yard> staticCache;

    public YardImpl(double value) {
        super(value, Length.INSTANCE, UnitIdentifier.YARD, YardImpl.class, dynamicCache, staticCache);
    }

    @Override
    public Yard fromBase(Meter base) {
        return (Yard)this.valueOf(base.getValue() / 0.9144);
    }

    @Override
    public Meter toBase() {
        return FactoryLength.meter(this.value * 0.9144);
    }

    @Override
    protected Yard _this() {
        return this;
    }

    @Override
    protected Yard _new_instance(double value) {
        return new YardImpl(value);
    }

    static {
        int sizeDyn = Preferences.getInt("yard.cache.dynamic.size", 0);
        dynamicCache = sizeDyn > 0 ? Caches.newInstance(UnitIdentifier.YARD, Math.abs(sizeDyn)) : null;
        int sizeStatic = Preferences.getInt("yard.cache.static.size", 1);
        staticCache = sizeStatic > 0 ? new StaticCache(Preferences.getInt("yard.cache.static.low", 0), sizeStatic, YardImpl.class) : null;
    }
}

