/*
 * Decompiled with CFR 0.152.
 */
package org.rojo.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rojo.annotations.Entity;
import org.rojo.annotations.Id;
import org.rojo.annotations.Index;
import org.rojo.annotations.Value;
import org.rojo.exceptions.InvalidTypeException;
import org.rojo.exceptions.RojoException;
import org.rojo.repository.IdGenerator;

public class EntityRepresentation {
    private static final Map<Class<? extends Object>, EntityRepresentation> knownEntities = new HashMap<Class<? extends Object>, EntityRepresentation>();
    private static final Map<String, EntityRepresentation> tableEntities = new HashMap<String, EntityRepresentation>();
    private boolean cacheable;
    private boolean idCache;
    private String table;
    private Field id;
    private final Field[] fields;
    private final String[] columns;
    private Field unique;
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();
    private final Map<String, String> columnMap = new HashMap<String, String>();
    private final List<Field> indexes = new ArrayList<Field>();
    private IdGenerator idGenerator;
    private boolean autoId;

    public static EntityRepresentation forClass(Class<? extends Object> entityClass) {
        if (knownEntities.containsKey(entityClass)) {
            return knownEntities.get(entityClass);
        }
        EntityRepresentation entityRepresentation = new EntityRepresentation(entityClass);
        knownEntities.put(entityClass, entityRepresentation);
        EntityRepresentation old = tableEntities.put(entityRepresentation.table, entityRepresentation);
        if (old != null) {
            throw new RojoException("duplicate table:" + entityRepresentation.table);
        }
        return entityRepresentation;
    }

    private EntityRepresentation(Class<? extends Object> entityClass) {
        this.verifyEntityAnnotation(entityClass);
        this.cacheable = entityClass.getAnnotation(Entity.class).cache();
        this.idCache = entityClass.getAnnotation(Entity.class).idCache();
        this.table = entityClass.getAnnotation(Entity.class).table();
        if (this.table.isEmpty()) {
            this.table = entityClass.getSimpleName();
        }
        this.allField(entityClass);
        if (this.id == null) {
            this.error(entityClass, "missing @Id field!");
        }
        this.fields = new Field[this.fieldMap.size()];
        this.columns = new String[this.fieldMap.size()];
        this.fieldMap.values().toArray(this.fields);
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.fields[i].isAnnotationPresent(Value.class)) {
                this.columns[i] = this.fields[i].getAnnotation(Value.class).column();
            }
            if (this.columns[i] == null || this.columns[i].isEmpty()) {
                this.columns[i] = this.fields[i].getName();
            }
            this.columnMap.put(this.fields[i].getName(), this.columns[i]);
        }
    }

    private void allField(Class<? extends Object> claz) {
        Field[] fs;
        for (Field f : fs = claz.getDeclaredFields()) {
            if (f.isAnnotationPresent(Id.class)) {
                if (this.id == null) {
                    if (f.getType() != String.class) {
                        this.error(claz, "invalid @Id field type! accepted types are {String}");
                    }
                    f.setAccessible(true);
                    this.id = f;
                    this.fieldMap.put(f.getName(), f);
                    Id annotation = this.id.getAnnotation(Id.class);
                    this.idGenerator = IdGenerator.getGenerator(annotation.generator());
                    this.autoId = annotation.auto();
                    if (this.idGenerator != null) continue;
                    this.error(claz, "idGenerator is null!");
                    continue;
                }
                this.error(claz, "duplicate @Id field type !");
                continue;
            }
            if (!f.isAnnotationPresent(Value.class)) continue;
            if (Collection.class.isAssignableFrom(f.getType()) && f.getType() != Set.class && f.getType() != List.class && f.getType() != Collection.class) {
                this.error(claz, "only Collection, Set and List are supported");
            }
            Value value = f.getAnnotation(Value.class);
            f.setAccessible(true);
            this.fieldMap.put(f.getName(), f);
            if (f.isAnnotationPresent(Index.class)) {
                this.indexes.add(f);
            }
            if (!value.unique()) continue;
            if (this.unique == null && f.getType() != byte[].class) {
                this.unique = f;
                continue;
            }
            this.error(claz, "more than one unique field or blob unique.");
        }
        Class<? extends Object> sclaz = claz.getSuperclass();
        if (sclaz != null) {
            this.allField(sclaz);
        }
    }

    private void verifyEntityAnnotation(Class<? extends Object> entityClass) {
        if (entityClass.getAnnotation(Entity.class) == null) {
            this.error(entityClass, "missing @Entity annotation");
        }
    }

    private void error(Class<? extends Object> entityClass, String msg) {
        throw new InvalidTypeException(entityClass.getCanonicalName() + ": " + msg);
    }

    public Field getUnique() {
        return this.unique;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public boolean isAutoId() {
        return this.autoId;
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String getId(Object entity) {
        return this.readId(entity, this.id);
    }

    public void setId(Object entity, String idValue) {
        try {
            this.id.set(entity, idValue);
        }
        catch (Exception e) {
            throw new InvalidTypeException(e);
        }
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public Field getField(String k) {
        return this.fieldMap.get(k);
    }

    String getColumn(String f) {
        return this.columnMap.get(f);
    }

    private String readId(Object entity, Field id) {
        String returnValue = null;
        try {
            Object o = id.get(entity);
            returnValue = o == null ? null : o.toString();
        }
        catch (Exception e) {
            throw new RojoException("access error" + e.getMessage());
        }
        return returnValue;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cache) {
        this.cacheable = cache;
    }

    public void setIdCache(boolean idCache) {
        this.idCache = idCache;
    }

    public boolean isIdCache() {
        return this.idCache;
    }

    Object readProperty(Object entity, Field f) {
        try {
            Object o = f.get(entity);
            return o;
        }
        catch (Exception ex) {
            throw new RojoException("access error" + ex.getMessage());
        }
    }

    public List<Field> getIndexes() {
        return this.indexes;
    }

    boolean isSampleEntity() {
        return this.unique == null && this.indexes.isEmpty();
    }
}

