/*
 * Decompiled with CFR 0.152.
 */
package org.rojo.repository;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rojo.annotations.Index;
import org.rojo.annotations.Value;
import org.rojo.exceptions.InvalidTypeException;
import org.rojo.repository.EntityRepresentation;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisFacade {
    private final Jedis je;
    private final Pipeline pipe;
    private static final String FOR_ALLFIELD_KEY = "001all_propertiesHashMap_key";
    private static final String FOR_ALL_IDS_SET_KEY = "002all_ids_key";
    private static final String FOR_SORTED_KEY = "003sorted_key";
    private static final String FOR_UNIQUE_KEY = "004unique_key";
    private static final String FOR_INDEX_KEY = "005indexing_key";
    private static final String NULL = "#*%$NULL@&%$#*{)}}(";

    public RedisFacade(Jedis jrClient) {
        this.je = jrClient;
        this.pipe = this.je.pipelined();
    }

    public <T> T readValue(String table, String id, String column, Field field) throws UnsupportedEncodingException {
        byte[] v = this.je.hget(this.keyForAllField(table, id).getBytes("UTF-8"), column.getBytes("UTF-8"));
        Class<?> t = field.getType();
        return RedisFacade.decode(t, v);
    }

    public <T> void readValues(String table, String id, String column, Field field, Collection<T> destination) {
        List values = this.je.lrange(this.keyForField(table, id, column), 0L, -1L);
        for (String value : values) {
            destination.add(RedisFacade.decode((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], value));
        }
    }

    <K, V> void readValues(String table, String id, String column, Field f, Map<K, V> dest) {
        Map values = this.je.hgetAll(this.keyForField(table, id, column));
        for (Map.Entry en : values.entrySet()) {
            Type[] ts = ((ParameterizedType)f.getGenericType()).getActualTypeArguments();
            Class keyClaz = (Class)ts[0];
            Class valueClaz = (Class)ts[1];
            dest.put(RedisFacade.decode(keyClaz, en.getKey()), RedisFacade.decode(valueClaz, en.getValue()));
        }
    }

    <T> void processFields(T entity, EntityRepresentation representation, String id) throws Exception {
        int i;
        Field[] fields = representation.getFields();
        String[] columns = representation.getColumns();
        String table = representation.getTable();
        Response[] rs = new Response[fields.length];
        for (i = 0; i < rs.length; ++i) {
            rs[i] = this.readFuture(table, id, columns[i], fields[i]);
        }
        this.sync();
        for (i = 0; i < rs.length; ++i) {
            if (Collection.class.isAssignableFrom(fields[i].getType())) {
                Collection holder = RedisFacade.initCollectionHolder(fields[i]);
                List r = (List)rs[i].get();
                for (String value : r) {
                    holder.add(RedisFacade.decode((Class)((ParameterizedType)fields[i].getGenericType()).getActualTypeArguments()[0], value));
                }
                fields[i].set(entity, holder);
                continue;
            }
            if (Map.class.isAssignableFrom(fields[i].getType())) {
                Map map = RedisFacade.initMapHolder(fields[i]);
                Map values = (Map)rs[i].get();
                Type[] ts = ((ParameterizedType)fields[i].getGenericType()).getActualTypeArguments();
                for (Map.Entry en : values.entrySet()) {
                    Class keyClaz = (Class)ts[0];
                    Class valueClaz = (Class)ts[1];
                    T k = RedisFacade.decode(keyClaz, en.getKey());
                    if (k == null) continue;
                    map.put(k, RedisFacade.decode(valueClaz, en.getValue()));
                }
                fields[i].set(entity, map);
                continue;
            }
            T temp = RedisFacade.decode(fields[i].getType(), rs[i].get());
            if (temp == null) continue;
            fields[i].set(entity, temp);
        }
    }

    private String keyForAll(String table) {
        return table + ":" + FOR_ALL_IDS_SET_KEY;
    }

    private String keyForField(String table, String id, String column) {
        return table + ":" + id + ":" + column;
    }

    private String keyForAllField(String table, String id) {
        return table + ":" + id + ":" + FOR_ALLFIELD_KEY;
    }

    private String keyForSorted(String table, String column) {
        return table + ":" + column + ":" + FOR_SORTED_KEY;
    }

    private String keyForUnique(String table, String column, String v) {
        return table + ":" + column + ":" + v + ":" + FOR_UNIQUE_KEY;
    }

    private String keyForIndex(String table, String column, String v) {
        return table + ":" + column + ":" + v + ":" + FOR_INDEX_KEY;
    }

    boolean write(String table, String id, String column, Object v, Field field, boolean withIndexing) {
        try {
            Index index;
            this.pipe.hset(this.keyForAllField(table, id), column, v.toString());
            Value annotation = field.getAnnotation(Value.class);
            if (annotation.sort()) {
                String key = this.keyForSorted(table, column);
                this.pipe.zadd(key, this.toDouble(v), String.valueOf(id));
                if (annotation.size() > 0L) {
                    if (annotation.bigFirst()) {
                        this.pipe.zremrangeByRank(key, 0L, -annotation.size() - 1L);
                    } else {
                        this.pipe.zremrangeByRank(key, annotation.size(), -1L);
                    }
                }
            }
            if (withIndexing && !annotation.unique() && (index = field.getAnnotation(Index.class)) != null) {
                this.pipe.zadd(this.keyForIndex(table, column, v.toString()), (double)System.currentTimeMillis(), String.valueOf(id));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean writeBlob(String table, String id, String column, byte[] v, Field field) {
        try {
            if (v != null) {
                this.pipe.hset(this.keyForAllField(table, id).getBytes("UTF-8"), column.getBytes("UTF-8"), v);
            } else {
                this.pipe.hdel(this.keyForAllField(table, id).getBytes("UTF-8"), (byte[][])new byte[][]{column.getBytes("UTF-8")});
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean update(String table, String id, String column, Object v, Field field) {
        try {
            Value annotation = field.getAnnotation(Value.class);
            if (annotation.unique() || field.isAnnotationPresent(Index.class)) {
                return false;
            }
            if (v != null) {
                this.pipe.hset(this.keyForAllField(table, id), column, v.toString());
                if (annotation.sort()) {
                    String key = this.keyForSorted(table, column);
                    this.pipe.zadd(key, this.toDouble(v), String.valueOf(id));
                    if (annotation.size() > 0L) {
                        if (annotation.bigFirst()) {
                            this.pipe.zremrangeByRank(key, 0L, -annotation.size() - 1L);
                        } else {
                            this.pipe.zremrangeByRank(key, annotation.size(), -1L);
                        }
                    }
                }
            } else {
                this.pipe.hdel(this.keyForAllField(table, id), new String[]{column});
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void writeCollection(String table, Collection<? extends Object> collection, String id, String column) {
        String key = this.keyForField(table, id, column);
        this.pipe.del(key);
        if (collection != null) {
            String[] vs = new String[collection.size()];
            int i = 0;
            for (Object object : collection) {
                vs[i++] = object == null ? NULL : object.toString();
            }
            this.pipe.rpush(key, vs);
        }
    }

    void writeMap(String table, Map<Object, Object> map, String id, String column) {
        String key = this.keyForField(table, id, column);
        this.pipe.del(key);
        if (map != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<Object, Object> en : map.entrySet()) {
                Object k = en.getKey();
                if (k == null) continue;
                m.put(k.toString(), en.getValue() == null ? NULL : en.getValue().toString());
            }
            this.pipe.hmset(key, m);
        }
    }

    void delete(String table, String id, String column, Field field) {
        Value annotation;
        if (Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) {
            this.pipe.del(this.keyForField(table, id, column));
        }
        if ((annotation = field.getAnnotation(Value.class)) != null && annotation.sort()) {
            this.pipe.zrem(this.keyForSorted(table, column), new String[]{String.valueOf(id)});
        }
    }

    void delete(String table, String id) {
        this.pipe.del(this.keyForAllField(table, id));
    }

    long incr(String s) {
        return this.je.incr(s);
    }

    boolean exists(String table, String id) {
        return this.je.exists(this.keyForAllField(table, id));
    }

    boolean uniqueExists(String table, String column, String v) {
        return this.je.exists(this.keyForUnique(table, column, v));
    }

    void flush() {
        this.pipe.sync();
    }

    public static <T> T decode(Class<?> t, Object o) {
        if (t == byte[].class) {
            return (T)(RedisFacade.isNull(o) ? null : o);
        }
        String v = (String)o;
        if (t == Integer.class) {
            return (T)(RedisFacade.isNull(v) ? null : Integer.valueOf(Integer.parseInt(v)));
        }
        if (t == Integer.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Integer(0) : Integer.valueOf(Integer.parseInt(v)));
        }
        if (t == String.class) {
            return (T)(RedisFacade.isNull(v) ? null : v);
        }
        if (t == Long.class) {
            return (T)(RedisFacade.isNull(v) ? null : Long.valueOf(Long.parseLong(v)));
        }
        if (t == Long.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Long(0L) : Long.valueOf(Long.parseLong(v)));
        }
        if (t == Float.class) {
            return (T)(RedisFacade.isNull(v) ? null : Float.valueOf(Float.parseFloat(v)));
        }
        if (t == Float.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Float(0.0f) : Float.valueOf(Float.parseFloat(v)));
        }
        if (t == Double.class) {
            return (T)(RedisFacade.isNull(v) ? null : Double.valueOf(Double.parseDouble(v)));
        }
        if (t == Double.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Double(0.0) : Double.valueOf(Double.parseDouble(v)));
        }
        if (t == Short.class) {
            return (T)(RedisFacade.isNull(v) ? null : Short.valueOf(Short.parseShort(v)));
        }
        if (t == Short.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Short(0) : Short.valueOf(Short.parseShort(v)));
        }
        if (t == Byte.class) {
            return (T)(RedisFacade.isNull(v) ? null : Byte.valueOf(Byte.parseByte(v)));
        }
        if (t == Byte.TYPE) {
            return (T)(RedisFacade.isNull(v) ? new Byte(0) : Byte.valueOf(Byte.parseByte(v)));
        }
        if (t == Boolean.class) {
            return (T)(RedisFacade.isNull(v) ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
        }
        if (t == Boolean.TYPE) {
            return (T)(RedisFacade.isNull(v) ? Boolean.FALSE : Boolean.valueOf(Boolean.parseBoolean(v)));
        }
        throw new InvalidTypeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + t);
    }

    private double toDouble(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        throw new InvalidTypeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + value.getClass());
    }

    private static boolean isNull(Object v) {
        boolean r = v == null || v.equals(NULL);
        return r;
    }

    Set<String> range(String table, String column, Field f, long start, long end) {
        String key = this.keyForSorted(table, column);
        Set s = null;
        Value annotation = f.getAnnotation(Value.class);
        if (annotation != null && annotation.sort()) {
            s = annotation.bigFirst() ? this.je.zrevrange(key, start, end) : this.je.zrange(key, start, end);
        }
        return s;
    }

    Set<String> scoreRange(String table, String column, Field f, double start, double end) {
        String key = this.keyForSorted(table, column);
        Set s = null;
        Value annotation = f.getAnnotation(Value.class);
        if (annotation != null && annotation.sort()) {
            s = annotation.bigFirst() ? this.je.zrevrangeByScore(key, start, end) : this.je.zrangeByScore(key, start, end);
        }
        return s;
    }

    long rank(String table, String column, Field f, String id) {
        Long index = null;
        Value annotation = f.getAnnotation(Value.class);
        if (annotation != null && annotation.sort()) {
            String key = this.keyForSorted(table, column);
            index = annotation.bigFirst() ? this.je.zrevrank(key, id) : this.je.zrank(key, id);
        }
        return index == null ? -1L : index;
    }

    boolean writeUnique(Object entity, Field unique, String table, String column, String id) {
        Object v;
        try {
            v = unique.get(entity);
            if (v == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        long r = this.je.setnx(this.keyForUnique(table, column, v.toString()), id);
        return r == 1L;
    }

    Response readFuture(String table, String id, String column, Field field) throws UnsupportedEncodingException {
        if (Collection.class.isAssignableFrom(field.getType())) {
            return this.pipe.lrange(this.keyForField(table, id, column), 0L, -1L);
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            return this.pipe.hgetAll(this.keyForField(table, id, column));
        }
        if (field.getType() == byte[].class) {
            return this.pipe.hget(this.keyForAllField(table, id).getBytes("UTF-8"), column.getBytes("UTF-8"));
        }
        return this.pipe.hget(this.keyForAllField(table, id), column);
    }

    void sync() {
        this.pipe.sync();
    }

    static Collection initCollectionHolder(Field field) {
        if (field.getType() == List.class || field.getType() == Collection.class) {
            return new ArrayList();
        }
        if (field.getType() == Set.class) {
            return new LinkedHashSet();
        }
        throw new InvalidTypeException("unsupported Collection subtype");
    }

    static Map initMapHolder(Field f) {
        return new HashMap();
    }

    void removeUnique(Object entity, Field unique, String table, String column) {
        try {
            this.pipe.del(this.keyForUnique(table, column, unique.get(entity).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void deleteIndex(String table, String column, String v, String id) {
        this.pipe.zrem(this.keyForIndex(table, column, v), new String[]{String.valueOf(id)});
    }

    long indexSize(String table, String column, Object v) {
        String key = this.keyForIndex(table, column, v.toString());
        return this.je.zcard(key);
    }

    Set<String> index(String table, String column, Object v, long start, long end) {
        String key = this.keyForIndex(table, column, v.toString());
        Set set = this.je.zrange(key, start, end);
        return set;
    }

    String unique(String table, String column, String v) {
        String key = this.keyForUnique(table, column, v);
        return this.je.get(key);
    }

    Set<String> all(String table, long start, long end) {
        String key = this.keyForAll(table);
        return this.je.zrange(key, start, end);
    }

    Set<String> all(String table, Date start, Date end) {
        String key = this.keyForAll(table);
        return this.je.zrangeByScore(key, start == null ? 0.0 : (double)start.getTime(), end == null ? (double)System.currentTimeMillis() : (double)end.getTime());
    }

    long allSize(String table) {
        String key = this.keyForAll(table);
        return this.je.zcard(key);
    }

    void addId(String table, String id) {
        String key = this.keyForAll(table);
        this.pipe.zadd(key, (double)System.currentTimeMillis(), id);
    }

    void deleteId(String table, String id) {
        String key = this.keyForAll(table);
        this.pipe.zrem(key, new String[]{id});
    }

    Date createTime(String table, String id) {
        String key = this.keyForAll(table);
        Double d = this.je.zscore(key, id);
        if (d != null) {
            return new Date((long)d.doubleValue());
        }
        return null;
    }

    Jedis getJedis() {
        return this.je;
    }
}

