/*
 * Decompiled with CFR 0.152.
 */
package org.rojo.repository;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rojo.annotations.Index;
import org.rojo.exceptions.RepositoryError;
import org.rojo.repository.CacheoutListerner;
import org.rojo.repository.DefaultGenerator;
import org.rojo.repository.EntityRepresentation;
import org.rojo.repository.RedisFacade;
import org.rojo.repository.SoftCache;
import redis.clients.jedis.Jedis;

public class Rojo {
    private static final Logger LOG = Logger.getLogger(Rojo.class.getName());
    private final RedisFacade store;
    private static SoftCache cache;
    private static int TIMES_CACHE_CLEAR;
    private static volatile long read;
    private static volatile long write;
    private static volatile boolean cacheable;

    public Rojo(Jedis je) {
        this.store = new RedisFacade(je);
    }

    public Jedis getJedis() {
        return this.store.getJedis();
    }

    public <T> Set<T> all(Class<T> c, long start, long end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(c);
            String table = representation.getTable();
            Set<String> s = this.store.all(table, start, end);
            ++read;
            LinkedHashSet<T> r = new LinkedHashSet<T>(s.size());
            for (String item : s) {
                r.add(this.get(c, item));
            }
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public long allSize(Class c, Date start, Date end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(c);
            String table = representation.getTable();
            Set<String> s = this.store.all(table, start, end);
            ++read;
            return s.size();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return -1L;
        }
    }

    public long allSize(Class c) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(c);
            String table = representation.getTable();
            long l = this.store.allSize(table);
            ++read;
            return l;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return -1L;
        }
    }

    public <T> Set<T> all(Class<T> c, Date start, Date end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(c);
            String table = representation.getTable();
            Set<String> s = this.store.all(table, start, end);
            ++read;
            LinkedHashSet<T> r = new LinkedHashSet<T>(s.size());
            for (String item : s) {
                r.add(this.get(c, item));
            }
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public Date createTime(Class c, String id) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(c);
            String table = representation.getTable();
            ++read;
            return this.store.createTime(table, id);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public void flush() {
        this.store.flush();
        ++write;
    }

    public String saveAndFlush(Object entity) {
        String id = this.save(entity);
        if (id != null) {
            this.store.flush();
            ++write;
        }
        return id;
    }

    private String save(Object entity) {
        try {
            boolean result;
            EntityRepresentation representation = EntityRepresentation.forClass(entity.getClass());
            String id = representation.getId(entity);
            String table = representation.getTable();
            boolean auto = representation.isAutoId();
            boolean idCache = representation.isIdCache();
            if (auto && Rojo.isEmpty(id)) {
                id = representation.getIdGenerator().id(entity.getClass(), table, this.store.getJedis());
                ++write;
            }
            if (Rojo.isEmpty(id)) {
                return null;
            }
            Field unique = representation.getUnique();
            if (unique != null && !(result = this.store.writeUnique(entity, unique, table, representation.getColumn(unique.getName()), id))) {
                return null;
            }
            Field[] fs = representation.getFields();
            for (int i = 0; i < fs.length; ++i) {
                Field field = fs[i];
                if (field.get(entity) == null) continue;
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection collection = (Collection)field.get(entity);
                    this.store.writeCollection(table, collection, id, representation.getColumns()[i]);
                    continue;
                }
                if (Map.class.isAssignableFrom(field.getType())) {
                    Map map = (Map)field.get(entity);
                    this.store.writeMap(table, map, id, representation.getColumns()[i]);
                    continue;
                }
                Object v = field.get(entity);
                if (v instanceof byte[]) {
                    this.store.writeBlob(table, id, representation.getColumns()[i], (byte[])v, field);
                    continue;
                }
                this.store.write(table, id, representation.getColumns()[i], v, field, true);
            }
            representation.setId(entity, id);
            if (idCache) {
                this.store.addId(table, id);
            }
            return id;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public boolean update(Object entity, String ... ps) {
        try {
            Class<?> claz = entity.getClass();
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            String id = representation.getId(entity);
            if (id != null) {
                for (String p : ps) {
                    Field f = representation.getField(p);
                    String column = representation.getColumn(p);
                    Object v = representation.readProperty(entity, f);
                    if (Collection.class.isAssignableFrom(f.getType())) {
                        this.store.writeCollection(table, (Collection)v, id, column);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(f.getType())) {
                        this.store.writeMap(table, (Map)v, id, column);
                        continue;
                    }
                    if (f.getType() == byte[].class) {
                        this.store.writeBlob(table, id, column, (byte[])v, f);
                        continue;
                    }
                    this.store.update(table, id, column, v, f);
                }
                return true;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
        }
        return false;
    }

    public boolean update(Object entity) {
        try {
            Class<?> claz = entity.getClass();
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            String id = representation.getId(entity);
            if (id != null) {
                for (String p : representation.getColumns()) {
                    Field f = representation.getField(p);
                    String column = representation.getColumn(p);
                    Object v = representation.readProperty(entity, f);
                    if (Collection.class.isAssignableFrom(f.getType())) {
                        this.store.writeCollection(table, (Collection)v, id, column);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(f.getType())) {
                        this.store.writeMap(table, (Map)v, id, column);
                        continue;
                    }
                    if (f.getType() == byte[].class) {
                        this.store.writeBlob(table, id, column, (byte[])v, f);
                        continue;
                    }
                    this.store.update(table, id, column, v, f);
                }
                return true;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
        }
        return false;
    }

    public boolean updateAndFlush(Object entity, String ... ps) {
        if (this.update(entity, ps)) {
            this.flush();
            ++write;
            return true;
        }
        return false;
    }

    public boolean updateAndFlush(Object entity) {
        if (this.update(entity)) {
            this.flush();
            ++write;
            return true;
        }
        return false;
    }

    public <T> T get(Class<T> claz, String id) {
        T entity = this.getFromCache(claz, id);
        if (entity != null) {
            return entity;
        }
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            ++read;
            if (!this.store.exists(table, id)) {
                return null;
            }
            entity = claz.newInstance();
            representation.setId(entity, id);
            this.store.processFields(entity, representation, id);
            ++read;
            if (cacheable && representation.isCacheable()) {
                this.cache(entity, id);
            }
            return entity;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            throw new RepositoryError(e);
        }
    }

    public boolean exist(Class claz, String id) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            ++read;
            return this.store.exists(table, id);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return false;
        }
    }

    public <T> T get(Class<T> claz, String id, String p) {
        try {
            T entity;
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            Field f = representation.getField(p);
            String table = representation.getTable();
            String column = representation.getColumn(p);
            if (cacheable && representation.isCacheable() && (entity = this.getFromCache(claz, id)) != null) {
                return (T)f.get(entity);
            }
            ++read;
            if (Collection.class.isAssignableFrom(f.getType())) {
                Collection holder = RedisFacade.initCollectionHolder(f);
                this.store.readValues(table, id, column, f, holder);
                return (T)holder;
            }
            if (Map.class.isAssignableFrom(f.getType())) {
                Map map = RedisFacade.initMapHolder(f);
                this.store.readValues(table, id, column, f, map);
                return (T)map;
            }
            return this.store.readValue(table, id, column, f);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public void deleteAndFlush(Object entity) {
        this.delete(entity);
        ++write;
        this.flush();
    }

    public void deleteAndFlush(Class claz, String id) {
        Rojo.evict(claz, id);
        Object temp = this.get(claz, id);
        if (temp != null) {
            this.deleteAndFlush(temp);
        }
    }

    public void delete(Object entity) {
        if (entity == null) {
            return;
        }
        Class<?> claz = entity.getClass();
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            String id = representation.getId(entity);
            if (id == null) {
                return;
            }
            Field unique = representation.getUnique();
            if (unique != null) {
                this.store.removeUnique(entity, unique, table, representation.getColumn(unique.getName()));
            }
            Field[] fs = representation.getFields();
            String[] columns = representation.getColumns();
            for (int i = 0; i < fs.length; ++i) {
                Field field = fs[i];
                this.store.delete(table, id, columns[i], field);
                Index index = field.getAnnotation(Index.class);
                if (index == null) continue;
                try {
                    Object v = field.get(entity);
                    if (v == null) continue;
                    this.store.deleteIndex(table, columns[i], v.toString(), id);
                    continue;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
                }
            }
            this.store.delete(table, id);
            this.store.deleteId(table, id);
            if (cacheable && representation.isCacheable()) {
                Rojo.evict(claz, id);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
        }
    }

    public <T> Set<T> range(Class<T> claz, String p, long start, long end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            Field f = representation.getField(p);
            String table = representation.getTable();
            String column = representation.getColumn(f.getName());
            Set<String> s = this.store.range(table, column, f, start, end);
            ++read;
            LinkedHashSet<T> r = new LinkedHashSet<T>(s.size());
            for (String item : s) {
                r.add(this.get(claz, item));
            }
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public <T> Set<T> scoreRange(Class<T> claz, String p, double start, double end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            Field f = representation.getField(p);
            String table = representation.getTable();
            String column = representation.getColumn(f.getName());
            Set<String> s = this.store.scoreRange(table, column, f, start, end);
            ++read;
            LinkedHashSet<T> r = new LinkedHashSet<T>(s.size());
            for (String item : s) {
                r.add(this.get(claz, item));
            }
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public long rank(Class claz, String id, String p) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            Field f = representation.getField(p);
            String table = representation.getTable();
            String column = representation.getColumn(p);
            ++read;
            return this.store.rank(table, column, f, id);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return -1L;
        }
    }

    public long indexSize(Class claz, String p, Object v) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            String column = representation.getColumn(p);
            long s = this.store.indexSize(table, column, v);
            ++read;
            return s;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return -1L;
        }
    }

    public <T> Set<T> index(Class<T> claz, String p, Object v) {
        return this.index(claz, p, v, 0L, -1L);
    }

    public <T> Set<T> index(Class<T> claz, String p, Object v, long start, long end) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            String table = representation.getTable();
            String column = representation.getColumn(p);
            Set<String> s = this.store.index(table, column, v, start, end);
            ++read;
            LinkedHashSet<T> r = new LinkedHashSet<T>(s.size());
            for (String item : s) {
                r.add(this.get(claz, item));
            }
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    public <T> T unique(Class<T> claz, Object v) {
        try {
            EntityRepresentation representation = EntityRepresentation.forClass(claz);
            Field unique = representation.getUnique();
            String table = representation.getTable();
            String column = representation.getColumn(unique.getName());
            String id = this.store.unique(table, column, v.toString());
            ++read;
            return id == null ? null : (T)this.get(claz, id);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "rojo error :{0}", e.getMessage());
            return null;
        }
    }

    private void cache(Object entity, String id) {
        if (cache != null) {
            cache.cache(entity, id);
        }
    }

    private <T> T getFromCache(Class<T> claz, String id) {
        return cache == null ? null : (T)cache.get(claz, id);
    }

    public static void evict(Class claz, String id) {
        if (cache != null) {
            cache.evict(claz, id);
        }
    }

    public static void clearCache(Class claz) {
        if (cache != null) {
            cache.clear(claz);
        }
    }

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    public static long getCachedObjectCounter() {
        return cache == null ? 0L : cache.cached();
    }

    public static void setCacheoutListerner(CacheoutListerner cacheoutListerner) {
        if (cache != null) {
            cache.setCacheoutListerner(cacheoutListerner);
        }
    }

    public static CacheoutListerner getCacheoutListerner() {
        return cache == null ? null : cache.getCacheoutListerner();
    }

    private static boolean isEmpty(String id) {
        return id == null || id.isEmpty();
    }

    public static long hit() {
        return cache == null ? 0L : cache.hit();
    }

    public static long miss() {
        return cache == null ? 0L : cache.miss();
    }

    public static long read() {
        return read;
    }

    public static long write() {
        return write;
    }

    public static long cacheout() {
        return cache == null ? 0L : cache.cacheout();
    }

    public static boolean isCacheable() {
        return cacheable;
    }

    public static void setCacheable(boolean cacheable) {
        Rojo.cacheable = cacheable;
        if (!cacheable) {
            Rojo.clearCache();
        } else if (cache == null) {
            cache = new SoftCache();
        }
    }

    static {
        new DefaultGenerator().configue("defaultGenerator");
        try {
            TIMES_CACHE_CLEAR = Integer.parseInt(System.getProperty("rojo.times.cache.clear", "15000"));
            cacheable = Boolean.parseBoolean(System.getProperty("rojo.cacheable", "false"));
            if (cacheable) {
                cache = new SoftCache();
                cache.setTIMES_CACHE_CLEAR(TIMES_CACHE_CLEAR);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "property rojo.times.cache.clear is missing,15000 will be applied");
        }
    }
}

