/*
 * Decompiled with CFR 0.152.
 */
package org.rojo.repository;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rojo.repository.CacheoutListerner;

public class SoftCache {
    private volatile long cachedObjectCounter;
    private volatile long cacheoutCounter;
    private CacheoutListerner cacheoutListerner;
    private volatile long hit;
    private volatile long miss;
    private int TIMES_CACHE_CLEAR = 15000;
    private volatile int timeCache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Map<Class, Map<String, SoftObjectReference<Object>>> cache = new HashMap<Class, Map<String, SoftObjectReference<Object>>>();
    private final ReferenceQueue<SoftObjectReference<Object>> rq = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Object entity, String id) {
        this.writeLock.lock();
        try {
            Map<String, SoftObjectReference<Object>> c = this.cache.get(entity.getClass());
            if (c == null) {
                c = new HashMap<String, SoftObjectReference<Object>>();
                this.cache.put(entity.getClass(), c);
            }
            c.put(id, new SoftObjectReference<Object>(entity, this.rq, id));
            ++this.cachedObjectCounter;
            ++this.timeCache;
            if (this.timeCache >= this.TIMES_CACHE_CLEAR) {
                SoftObjectReference sr;
                while ((sr = (SoftObjectReference)this.rq.poll()) != null) {
                    c = this.cache.get(sr.claz);
                    c.remove(sr.id);
                    --this.cachedObjectCounter;
                    this.onCacheout(sr.claz, sr.id);
                }
                this.timeCache = 0;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> claz, String id) {
        this.readLock.lock();
        try {
            SoftReference sr;
            Map<String, SoftObjectReference<Object>> c = this.cache.get(claz);
            if (c != null && (sr = (SoftReference)c.get(id)) != null) {
                Object r = sr.get();
                if (r != null) {
                    ++this.hit;
                }
                Object t = r;
                return t;
            }
            ++this.miss;
            T t = null;
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evict(Class claz, String id) {
        this.writeLock.lock();
        try {
            Map<String, SoftObjectReference<Object>> c = this.cache.get(claz);
            if (c != null) {
                boolean bl = c.remove(id) != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Class claz) {
        this.writeLock.lock();
        try {
            Map<String, SoftObjectReference<Object>> c = this.cache.get(claz);
            if (c != null) {
                this.cachedObjectCounter -= (long)c.size();
                c.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            SoftObjectReference sr;
            for (Map<String, SoftObjectReference<Object>> m : this.cache.values()) {
                m.clear();
            }
            while ((sr = (SoftObjectReference)this.rq.poll()) != null) {
                this.onCacheout(sr.claz, sr.id);
            }
            this.cachedObjectCounter = 0L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onCacheout(Class claz, String id) {
        ++this.cacheoutCounter;
        if (this.cacheoutListerner != null) {
            this.cacheoutListerner.onCacheout(claz, id);
        }
    }

    public long cached() {
        return this.cachedObjectCounter;
    }

    public long cacheout() {
        return this.cacheoutCounter;
    }

    public long hit() {
        return this.hit;
    }

    public long miss() {
        return this.miss;
    }

    public CacheoutListerner getCacheoutListerner() {
        return this.cacheoutListerner;
    }

    public void setCacheoutListerner(CacheoutListerner cacheoutListerner) {
        this.cacheoutListerner = cacheoutListerner;
    }

    public int getTIMES_CACHE_CLEAR() {
        return this.TIMES_CACHE_CLEAR;
    }

    public void setTIMES_CACHE_CLEAR(int TIMES_CACHE_CLEAR) {
        this.TIMES_CACHE_CLEAR = TIMES_CACHE_CLEAR;
    }

    private class SoftObjectReference<Object>
    extends SoftReference<Object> {
        public final String id;
        public final Class claz;

        public SoftObjectReference(Object r, ReferenceQueue q, String id) {
            super(r, q);
            this.id = id;
            this.claz = r.getClass();
        }
    }
}

