/*
 * Decompiled with CFR 0.152.
 */
package bighuggies.bisimulation;

import bighuggies.bisimulation.se705.bisimulation.BisimilarComputation;
import bighuggies.bisimulation.se705.bisimulation.lts.Process;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class BisimulationChecker {
    private Process processP;
    private Process processQ;
    private BisimilarComputation compute;

    public static void main(String[] args) throws IOException {
        BisimulationChecker bisim = new BisimulationChecker();
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please enter the file name of the first process: ");
        String fileP = stdin.readLine();
        fileP = bisim.checkFileName(fileP);
        System.out.println("Please enter the file name of the second process: ");
        String fileQ = stdin.readLine();
        fileQ = bisim.checkFileName(fileQ);
        String output = "foobar.txt";
        while (output.isEmpty()) {
            System.out.println("Please enter the file name of the output file: ");
            output = stdin.readLine();
        }
        bisim.readInput(fileP, fileQ);
        bisim.performBisimulation();
        bisim.writeOutput(output);
    }

    public void readInput(ByteArrayInputStream fileP, ByteArrayInputStream fileQ) {
        try {
            this.processP = Process.parse(fileP, "Process P", "p");
            this.processQ = Process.parse(fileQ, "Process Q", "q");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Process getProcessP() {
        return this.processP;
    }

    public void setProcessP(Process processP) {
        this.processP = processP;
    }

    public Process getProcessQ() {
        return this.processQ;
    }

    public void setProcessQ(Process processQ) {
        this.processQ = processQ;
    }

    public void writeOutput(OutputStream out) {
        try {
            out.write(this.processP.toString().getBytes(StandardCharsets.UTF_8));
            out.write(this.processQ.toString().getBytes(StandardCharsets.UTF_8));
            out.write(this.compute.toString().getBytes(StandardCharsets.UTF_8));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean areBisimilar() {
        return this.compute.isBisimilar();
    }

    public void readInput(String fileP, String fileQ) {
        try {
            this.processP = Process.parse(fileP, "Process P", "p");
            this.processQ = Process.parse(fileQ, "Process Q", "q");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String checkFileName(String fileName) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (fileName == null || !new File(fileName).exists()) {
            System.out.println("File \"" + fileName + "\" not found, please try again: ");
            try {
                fileName = stdin.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }

    public void performBisimulation() {
        this.compute = new BisimilarComputation(this.processP, this.processQ);
    }

    public void writeOutput(String filename) {
        try {
            FileWriter out = new FileWriter(new File(filename));
            out.write(this.processP.toString());
            out.write(this.processQ.toString());
            out.write(this.compute.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

