/*
 * Decompiled with CFR 0.152.
 */
package bighuggies.bisimulation.se705.bisimulation;

import bighuggies.bisimulation.se705.bisimulation.lts.Process;
import bighuggies.bisimulation.se705.bisimulation.lts.Transition;
import bighuggies.bisimulation.se705.bisimulation.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class BisimilarComputation {
    private final Process processP;
    private final Process processQ;
    private final Set<Set<String>> rho;
    private final Set<Transition> ts;

    public BisimilarComputation(Process p, Process q) {
        this.processP = p;
        this.processQ = q;
        this.ts = new HashSet<Transition>();
        this.ts.addAll(p.getTransitions());
        this.ts.addAll(q.getTransitions());
        HashSet<String> allStates = new HashSet<String>();
        allStates.addAll(p.getStates());
        allStates.addAll(q.getStates());
        HashSet<HashSet<String>> rhoinit = new HashSet<HashSet<String>>();
        rhoinit.add(allStates);
        TreeSet<String> sigma = new TreeSet<String>();
        sigma.addAll(p.getActions());
        sigma.addAll(q.getActions());
        this.rho = new HashSet<Set<String>>(rhoinit);
        HashSet<Set<String>> waiting = new HashSet<Set<String>>(rhoinit);
        do {
            Set<String> pprime = this.popStates(waiting);
            for (String action : sigma) {
                HashSet<Set<String>> matchP = new HashSet<Set<String>>();
                for (Set<String> partition : this.rho) {
                    Set<String> tap = this.t(partition, pprime, action);
                    if (tap.isEmpty() || tap.equals(partition)) continue;
                    matchP.add(partition);
                }
                for (Set<String> partition : matchP) {
                    Set<Set<String>> splitP = this.splitP(partition, pprime, action);
                    this.rho.remove(partition);
                    this.rho.addAll(splitP);
                    waiting.remove(partition);
                    waiting.addAll(splitP);
                }
            }
        } while (!waiting.isEmpty());
    }

    private Set<String> popStates(Set<Set<String>> stateSets) {
        Set<String> states = stateSets.iterator().next();
        stateSets.remove(states);
        return states;
    }

    private Set<Set<String>> splitP(Set<String> partition, Set<String> pprime, String action) {
        HashSet<Set<String>> splitP = new HashSet<Set<String>>();
        Set<String> tap = this.t(partition, pprime, action);
        HashSet<String> nottap = new HashSet<String>(partition);
        nottap.removeAll(tap);
        splitP.add(tap);
        splitP.add(nottap);
        return splitP;
    }

    private Set<String> t(Set<String> partition, Set<String> pprime, String action) {
        HashSet<String> acc = new HashSet<String>();
        for (String s : partition) {
            for (String d : pprime) {
                if (!this.ts.contains(new Transition(s, action, d))) continue;
                acc.add(s);
            }
        }
        return acc;
    }

    public boolean isBisimilar() {
        boolean isBisimilar = false;
        for (Set<String> partition : this.rho) {
            boolean fromP = false;
            boolean fromQ = false;
            for (String state : partition) {
                fromP = fromP || this.processP.getStates().contains(state);
                fromQ = fromQ || this.processQ.getStates().contains(state);
            }
            isBisimilar = fromP && fromQ;
            if (isBisimilar) continue;
            break;
        }
        return isBisimilar;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Bisimulation Results\n");
        for (Set<String> partition : this.rho) {
            out.append(StringUtil.join(StringUtil.wrapEach(StringUtil.removePrefixEach(partition), "state(%s)"), ",") + "\n");
        }
        out.append("Bisimulation Answer\n");
        out.append(this.isBisimilar() ? "Yes" : "No");
        return out.toString();
    }
}

