/*
 * Decompiled with CFR 0.152.
 */
package bighuggies.bisimulation.se705.bisimulation.lts;

import bighuggies.bisimulation.se705.bisimulation.lts.Transition;
import bighuggies.bisimulation.se705.bisimulation.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.TreeSet;

public class Process {
    private final String _name;
    private final Set<String> _states;
    private final Set<String> _actions;
    private final Set<Transition> _transitions;

    public Process(String processName) {
        this._name = processName;
        this._states = new TreeSet<String>();
        this._actions = new TreeSet<String>();
        this._transitions = new TreeSet<Transition>();
    }

    public static Process parse(ByteArrayInputStream inputReader, String processName, String prefix) throws IOException {
        String line;
        Process p = new Process(processName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputReader));
        while (!(line = reader.readLine()).equalsIgnoreCase("!")) {
            String[] parts = line.split(",|:");
            Process.putLineInProcess(p, parts, prefix);
        }
        reader.close();
        return p;
    }

    public static Process parse(String filePath, String processName, String prefix) throws IOException {
        String line;
        Process p = new Process(processName);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        while (!(line = reader.readLine()).equalsIgnoreCase("!")) {
            String[] parts = line.split(",|:");
            Process.putLineInProcess(p, parts, prefix);
        }
        reader.close();
        return p;
    }

    private static void putLineInProcess(Process p, String[] line, String prefix) {
        p.addState(prefix + line[0].trim());
        p.addState(prefix + line[2].trim());
        p.addAction(line[1].trim());
        p.addTransition(prefix + line[0].trim(), line[1].trim(), prefix + line[2].trim());
    }

    protected Process addAction(String action) {
        this.getActions().add(action);
        return this;
    }

    protected Process addState(String state) {
        this._states.add(state);
        return this;
    }

    protected Process addTransition(String source, String action, String destination) {
        this._transitions.add(new Transition(source, action, destination));
        return this;
    }

    public Set<String> getActions() {
        return this._actions;
    }

    public Set<String> getStates() {
        return this._states;
    }

    public Set<Transition> getTransitions() {
        return this._transitions;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this._name + "\n");
        b.append("S = ");
        b.append(StringUtil.join(StringUtil.wrapEach(StringUtil.removePrefixEach(this.getStates()), "state(%s)"), ",") + "\n");
        b.append("A = ");
        b.append(StringUtil.join(StringUtil.wrapEach(this.getActions(), "action(%s)"), ",") + "\n");
        b.append("T = ");
        b.append(StringUtil.join(this.getTransitions(), ",") + "\n");
        return b.toString();
    }
}

