/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core;

import it.uniud.mads.jlibbig.core.AbstractNamed;
import it.uniud.mads.jlibbig.core.Named;
import it.uniud.mads.jlibbig.core.util.NameGenerator;

public class Control
extends AbstractNamed
implements Named {
    protected int arity;

    public Control(int arity) {
        this("C_" + NameGenerator.DEFAULT.generate(), arity);
    }

    public Control(String name, int arity) {
        super(name);
        if (arity < 0) {
            throw new IllegalArgumentException("Arity should be greater or equal to zero.");
        }
        this.arity = arity;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.arity;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Control other = (Control)obj;
        return this.arity == other.arity && super.getName().equals(other.getName());
    }

    @Override
    public String toString() {
        return this.getName() + ":" + this.arity;
    }
}

