/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core;

import it.uniud.mads.jlibbig.core.AbstractNamed;
import it.uniud.mads.jlibbig.core.Control;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class Signature<C extends Control>
implements Iterable<C> {
    protected final Map<String, C> ctrls = new HashMap<String, C>();
    protected final String USID;

    public Signature(Iterable<? extends C> controls) {
        this((String)null, controls);
    }

    public Signature(String usid, Iterable<? extends C> controls) {
        for (Control c : controls) {
            if (this.ctrls.put(c.getName(), c) == null) continue;
            throw new IllegalArgumentException("Controls must be uniquely named within the same signature");
        }
        this.USID = usid == null || usid.trim().length() == 0 ? UUID.randomUUID().toString() : usid;
    }

    @SafeVarargs
    public Signature(C ... controls) {
        this(null, (Control[])controls);
    }

    @SafeVarargs
    public Signature(String usid, C ... controls) {
        this(usid, (Iterable<C>)Arrays.asList(controls));
    }

    protected void add(C control) {
        if (this.ctrls.containsKey(((AbstractNamed)control).getName()) && !this.ctrls.containsValue(control)) {
            throw new IllegalArgumentException("Controls must be uniquely named within the same signature");
        }
        this.ctrls.put(((AbstractNamed)control).getName(), control);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.USID.hashCode();
        result = 31 * result + this.ctrls.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        if (!this.USID.equals(other.USID)) {
            return false;
        }
        for (Control c : this.ctrls.values()) {
            if (c.equals(other.getByName(c.getName()))) continue;
            return false;
        }
        return this.ctrls.equals(other.ctrls);
    }

    public boolean equals(Signature<C> other) {
        return this.equals(other, false);
    }

    public boolean equals(Signature<C> other, boolean ignoreUSID) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.USID.equals(other.USID)) {
            return false;
        }
        for (Control c : this.ctrls.values()) {
            if (c.equals(other.getByName(c.getName()))) continue;
            return false;
        }
        return this.ctrls.equals(other.ctrls);
    }

    public String getUSID() {
        return this.USID.toString();
    }

    public C getByName(String name) {
        return (C)((Control)this.ctrls.get(name));
    }

    public String toString() {
        return this.USID + ":" + this.ctrls.values();
    }

    public boolean contains(String name) {
        return this.ctrls.containsKey(name);
    }

    public boolean contains(Control control) {
        return this.ctrls.containsValue(control);
    }

    public boolean isEmpty() {
        return this.ctrls.isEmpty();
    }

    @Override
    public Iterator<C> iterator() {
        return Collections.unmodifiableMap(this.ctrls).values().iterator();
    }

    public int size() {
        return this.ctrls.size();
    }
}

