/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ProtectedProperty;

public class DelegatedProperty<V>
extends ProtectedProperty<V> {
    protected boolean cacheValue = false;
    private Property<V> prop;
    private final PropertyListener<? super V> lst;
    private boolean registered = false;

    @SafeVarargs
    public DelegatedProperty(String name, boolean cacheValue, PropertySetter<V> setter, PropertyListener<? super V> ... listeners) {
        this(name, null, cacheValue, setter, listeners);
    }

    @SafeVarargs
    public DelegatedProperty(String name, Property<V> property, boolean cacheValue, PropertyListener<? super V> ... listeners) {
        this(name, (Property<? super V>)property, cacheValue, (PropertySetter<? super V>)null, listeners);
    }

    @SafeVarargs
    public DelegatedProperty(String name, Property<V> property, PropertyListener<? super V> ... listeners) {
        this(name, (Property<? super V>)property, true, (PropertySetter<? super V>)null, listeners);
    }

    @SafeVarargs
    public DelegatedProperty(String name, Property<V> property, PropertySetter<V> setter, PropertyListener<? super V> ... listeners) {
        this(name, property, true, setter, listeners);
    }

    @SafeVarargs
    public DelegatedProperty(String name, Property<V> property, boolean cacheValue, PropertySetter<V> setter, PropertyListener<? super V> ... listeners) {
        super(name, null, listeners);
        this.prop = property;
        this.cacheValue = cacheValue;
        this.lst = cacheValue ? new PropertyListener<V>(){

            @Override
            public void onChanged(Property<? extends V> property, V oldValue, V newValue) {
                DelegatedProperty.this.set(newValue, false);
            }
        } : new PropertyListener<V>(){

            @Override
            public void onChanged(Property<? extends V> property, V oldValue, V newValue) {
                DelegatedProperty.this.tellChanged(DelegatedProperty.this, oldValue, newValue);
            }
        };
        if (listeners.length > 0 && this.prop != null) {
            this.prop.registerListener(this.lst);
            this.registered = true;
            if (cacheValue) {
                this.set(this.prop.get(), true);
            }
        }
        if (setter != null) {
            setter.target = this;
        }
    }

    @Override
    public void registerListener(PropertyListener<? super V> listener) {
        super.registerListener(listener);
        if (!this.registered && this.prop != null) {
            this.prop.registerListener(this.lst);
            this.registered = true;
            if (this.cacheValue) {
                this.set(this.prop.get(), true);
            }
        }
    }

    @Override
    public boolean unregisterListener(PropertyListener<? super V> listener) {
        boolean r = super.unregisterListener(listener);
        if (this.registered && this.listeners.isEmpty()) {
            this.prop.unregisterListener(this.lst);
            this.registered = false;
        }
        return r;
    }

    public Property<V> getProperty() {
        return this.prop;
    }

    protected void setProperty(Property<V> prop) {
        if (this.prop != prop) {
            Object newValue;
            V oldValue = this.get();
            Object v = newValue = prop != null ? (Object)prop.get() : null;
            if (this.prop != null && this.registered) {
                this.prop.unregisterListener(this.lst);
            }
            this.prop = prop;
            if (prop != null && this.registered) {
                prop.registerListener(this.lst);
            }
            if (this.cacheValue) {
                super.set(newValue, true);
            }
            if (oldValue != newValue) {
                this.tellChanged(this, oldValue, this.get());
            }
        }
    }

    @Override
    public V get() {
        if (this.cacheValue) {
            return super.get();
        }
        if (this.prop == null) {
            return null;
        }
        return this.prop.get();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.prop != null && this.registered) {
                this.prop.unregisterListener(this.lst);
            }
        }
        finally {
            super.finalize();
        }
    }

    public static final class PropertySetter<V> {
        private DelegatedProperty<V> target;

        public DelegatedProperty<V> getTarget() {
            return this.target;
        }

        public void set(Property<V> prop) {
            this.target.setProperty(prop);
        }
    }
}

