/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class Property<V> {
    private final String name;
    protected boolean readOnly;
    private final List<PropertyListener<? super V>> _listeners = new LinkedList<PropertyListener<? super V>>();
    protected final Collection<PropertyListener<? super V>> listeners = Collections.unmodifiableCollection(this._listeners);

    public Property(String name) {
        this(name, true, null);
    }

    public Property(String name, boolean writable, Collection<? extends PropertyListener<? super V>> listeners) {
        if (name == null) {
            throw new IllegalArgumentException("The argument can not be null.");
        }
        this.name = name;
        boolean bl = this.readOnly = !writable;
        if (listeners != null) {
            this._listeners.addAll(listeners);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isListenerRegistered(PropertyListener<? super V> listener) {
        return this._listeners.contains(listener);
    }

    public void registerListener(PropertyListener<? super V> listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public boolean unregisterListener(PropertyListener<? super V> listener) {
        return this._listeners.remove(listener);
    }

    public abstract V get();

    public abstract V set(V var1);

    public final String getName() {
        return this.name;
    }

    protected void onAttach(PropertyTarget target) {
    }

    protected void onDetach(PropertyTarget target) {
    }

    public String toString() {
        return "Property '" + this.getName() + "'=" + this.get();
    }

    protected void tellChanged(Property<V> property, V oldValue, V newValue) {
        for (PropertyListener<V> listener : new ArrayList<PropertyListener<V>>(this.listeners)) {
            listener.onChanged(property, oldValue, newValue);
        }
    }
}

