/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyTarget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyContainer
implements PropertyTarget {
    private final Map<String, Property<?>> props = new HashMap();
    private final PropertyTarget alias;

    public PropertyContainer() {
        this.alias = this;
    }

    public PropertyContainer(PropertyTarget alias) {
        this.alias = alias == null ? this : alias;
    }

    @Override
    public Property<?> attachProperty(Property<?> prop) {
        String name = prop.getName();
        Property<?> old = this.props.get(name);
        if (old != null) {
            old.onDetach(this.alias);
        }
        prop.onAttach(this.alias);
        return this.props.put(prop.getName(), prop);
    }

    @Override
    public <V> Property<V> detachProperty(Property<V> prop) {
        if (this.props.containsValue(prop)) {
            return this.detachProperty(prop.getName());
        }
        return null;
    }

    @Override
    public <V> Property<V> detachProperty(String name) {
        Property<?> prop = this.props.remove(name);
        if (prop != null) {
            prop.onDetach(this.alias);
        }
        return prop;
    }

    @Override
    public <V> Property<V> getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.props.values();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.props.keySet();
    }
}

