/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.Replicating;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class ReplicationListenerContainer {
    private Collection<ReplicationListener> _listeners = new LinkedList<ReplicationListener>();
    protected Collection<ReplicationListener> listeners = Collections.unmodifiableCollection(this._listeners);

    public ReplicationListenerContainer(ReplicationListener ... listeners) {
        this._listeners.addAll(Arrays.asList(listeners));
    }

    public void registerListener(ReplicationListener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public boolean unregisterListener(ReplicationListener listener) {
        return this._listeners.remove(listener);
    }

    public boolean isListenerRegistered(ReplicationListener listener) {
        return this._listeners.contains(listener);
    }

    public void tellReplicated(Replicating original, Replicating copy) {
        for (ReplicationListener listener : new ArrayList<ReplicationListener>(this._listeners)) {
            listener.onReplicated(original, copy);
        }
    }
}

