/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyTarget;
import it.uniud.mads.jlibbig.core.attachedProperties.Replicating;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;

public class SharedProperty<V>
extends Property<V> {
    protected final Property<V> property;
    protected final ReplicationListener listener = new ReplicationListener(){

        @Override
        public void onReplicated(Replicating original, Replicating copy) {
            SharedProperty.this.onReplicated(original, copy);
        }
    };

    private static String retrieveName(Property<?> property) {
        if (property == null) {
            throw new IllegalArgumentException("The encapsulated property can not be null.");
        }
        return property.getName();
    }

    public SharedProperty(Property<V> property) {
        super(SharedProperty.retrieveName(property));
        this.property = property;
    }

    public Property<V> getProperty() {
        return this.property;
    }

    @Override
    public boolean isReadOnly() {
        return this.property.isReadOnly();
    }

    @Override
    public void registerListener(PropertyListener<? super V> listener) {
        this.property.registerListener(listener);
    }

    @Override
    public boolean isListenerRegistered(PropertyListener<? super V> listener) {
        return this.property.isListenerRegistered(listener);
    }

    @Override
    public boolean unregisterListener(PropertyListener<? super V> listener) {
        return this.property.unregisterListener(listener);
    }

    @Override
    public V get() {
        return this.property.get();
    }

    @Override
    public V set(V value) {
        return this.property.set(value);
    }

    @Override
    protected void onAttach(PropertyTarget target) {
        this.property.onAttach(target);
        if (target instanceof Replicating) {
            ((Replicating)((Object)target)).registerListener(this.listener);
        }
    }

    @Override
    protected void onDetach(PropertyTarget target) {
        this.property.onDetach(target);
        if (target instanceof Replicating) {
            ((Replicating)((Object)target)).unregisterListener(this.listener);
        }
    }

    protected void onReplicated(Replicating original, Replicating copy) {
        ((PropertyTarget)((Object)copy)).attachProperty(this);
        copy.registerListener(this.listener);
    }
}

