/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.attachedProperties;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import java.util.Arrays;
import java.util.Collection;

public class SimpleProperty<V>
extends Property<V> {
    private V value;

    @SafeVarargs
    public SimpleProperty(String name, PropertyListener<? super V> ... listeners) {
        this(name, (V)false, listeners);
    }

    @SafeVarargs
    public SimpleProperty(String name, boolean writable, PropertyListener<? super V> ... listeners) {
        this(name, writable, Arrays.asList(listeners));
    }

    public SimpleProperty(String name, boolean writable, Collection<? extends PropertyListener<? super V>> listeners) {
        super(name, writable, listeners);
    }

    @SafeVarargs
    public SimpleProperty(String name, V value, PropertyListener<? super V> ... listeners) {
        this(name, (V)value, false, listeners);
    }

    @SafeVarargs
    public SimpleProperty(String name, V value, boolean writable, PropertyListener<? super V> ... listeners) {
        this(name, (V)writable, listeners);
        this.value = value;
    }

    public SimpleProperty(String name, V value, boolean writable, Collection<? extends PropertyListener<? super V>> listeners) {
        this(name, writable, listeners);
        this.value = value;
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public V set(V value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Property '" + this.getName() + "' is read only.");
        }
        return this.set(value, false);
    }

    protected V set(V value, boolean silent) {
        V old = this.value;
        this.value = value;
        if (!silent && old != value) {
            this.tellChanged(this, old, value);
        }
        return old;
    }
}

