/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NameClashException
extends RuntimeException {
    private static final long serialVersionUID = 7906403825825798881L;
    private final Set<String> names;

    public NameClashException(Collection<String> collection) {
        this(null, collection);
    }

    public NameClashException(String message, Collection<String> names) {
        super(message);
        if (!names.isEmpty()) {
            HashSet<String> ns = new HashSet<String>();
            for (String n : names) {
                ns.add(n);
            }
            this.names = Collections.unmodifiableSet(ns);
        } else {
            this.names = null;
        }
    }

    public NameClashException(String message, String ... names) {
        super(message);
        if (names.length > 0) {
            HashSet<String> ns = new HashSet<String>();
            ns.addAll(Arrays.asList(names));
            this.names = Collections.unmodifiableSet(ns);
        } else {
            this.names = null;
        }
    }

    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public String toString() {
        if (this.names != null) {
            return super.toString() + "\nClash over '" + this.names + "'";
        }
        return super.toString();
    }
}

